/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.storage;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.SafeStateMarshal;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class DurableStateStorageTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private final LifeRule lifeRule = new LifeRule(true);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.lifeRule).around((TestRule)this.testDir);

    @Test
    public void shouldMaintainStateGivenAnEmptyInitialStore() throws Exception {
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        DurableStateStorage storage = (DurableStateStorage)this.lifeRule.add((Lifecycle)new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)new AtomicIntegerMarshal(), 100, (LogProvider)NullLogProvider.getInstance()));
        storage.persistStoreData((Object)new AtomicInteger(99));
        Assert.assertEquals((long)4L, (long)fsa.getFileSize(this.stateFileA()));
    }

    @Test
    public void shouldRotateToOtherStoreFileAfterSufficientEntries() throws Exception {
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        int numberOfEntriesBeforeRotation = 100;
        DurableStateStorage storage = (DurableStateStorage)this.lifeRule.add((Lifecycle)new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)new AtomicIntegerMarshal(), 100, (LogProvider)NullLogProvider.getInstance()));
        for (int i = 0; i < 100; ++i) {
            storage.persistStoreData((Object)new AtomicInteger(i));
        }
        storage.persistStoreData((Object)new AtomicInteger(9999));
        Assert.assertEquals((long)4L, (long)fsa.getFileSize(this.stateFileB()));
        Assert.assertEquals((long)400L, (long)fsa.getFileSize(this.stateFileA()));
    }

    @Test
    public void shouldRotateBackToFirstStoreFileAfterSufficientEntries() throws Exception {
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        int numberOfEntriesBeforeRotation = 100;
        DurableStateStorage storage = (DurableStateStorage)this.lifeRule.add((Lifecycle)new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)new AtomicIntegerMarshal(), 100, (LogProvider)NullLogProvider.getInstance()));
        for (int i = 0; i < 200; ++i) {
            storage.persistStoreData((Object)new AtomicInteger(i));
        }
        storage.persistStoreData((Object)new AtomicInteger(9999));
        Assert.assertEquals((long)4L, (long)fsa.getFileSize(this.stateFileA()));
        Assert.assertEquals((long)400L, (long)fsa.getFileSize(this.stateFileB()));
    }

    @Test
    public void shouldClearFileOnFirstUse() throws Throwable {
        int largestValueWritten;
        EphemeralFileSystemAbstraction fsa = this.fileSystemRule.get();
        fsa.mkdir(this.testDir.directory());
        int rotationCount = 10;
        DurableStateStorage storage = new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)new AtomicIntegerMarshal(), rotationCount, (LogProvider)NullLogProvider.getInstance());
        try (Lifespan lifespan = new Lifespan(new Lifecycle[]{storage});){
            for (largestValueWritten = 0; largestValueWritten < rotationCount * 2; ++largestValueWritten) {
                storage.persistStoreData((Object)new AtomicInteger(largestValueWritten));
            }
        }
        storage = (DurableStateStorage)this.lifeRule.add((Lifecycle)new DurableStateStorage((FileSystemAbstraction)fsa, this.testDir.directory(), "state", (StateMarshal)new AtomicIntegerMarshal(), rotationCount, (LogProvider)NullLogProvider.getInstance()));
        storage.persistStoreData((Object)new AtomicInteger(largestValueWritten++));
        storage.persistStoreData((Object)new AtomicInteger(largestValueWritten++));
        storage.persistStoreData((Object)new AtomicInteger(largestValueWritten));
        ByteBuffer forReadingBackIn = ByteBuffer.allocate(10000);
        StoreChannel lastWrittenTo = fsa.open(this.stateFileA(), "r");
        lastWrittenTo.read(forReadingBackIn);
        forReadingBackIn.flip();
        AtomicInteger lastRead = null;
        try {
            while (true) {
                lastRead = new AtomicInteger(forReadingBackIn.getInt());
            }
        }
        catch (BufferUnderflowException e) {
            Assert.assertNotNull(lastRead);
            Assert.assertEquals((long)largestValueWritten, (long)lastRead.get());
            return;
        }
    }

    private File stateFileA() {
        return new File(new File(this.testDir.directory(), "state-state"), "state.a");
    }

    private File stateFileB() {
        return new File(new File(this.testDir.directory(), "state-state"), "state.b");
    }

    private static class AtomicIntegerMarshal
    extends SafeStateMarshal<AtomicInteger> {
        private AtomicIntegerMarshal() {
        }

        public void marshal(AtomicInteger state, WritableChannel channel) throws IOException {
            channel.putInt(state.intValue());
        }

        public AtomicInteger unmarshal0(ReadableChannel channel) throws IOException {
            return new AtomicInteger(channel.getInt());
        }

        public AtomicInteger startState() {
            return new AtomicInteger(0);
        }

        public long ordinal(AtomicInteger atomicInteger) {
            return atomicInteger.get();
        }
    }
}

