/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.snapshot;

import java.io.File;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.core.state.CoreState;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateDownloader;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CoreStateDownloaderTest {
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LocalDatabase localDatabase = (LocalDatabase)Mockito.mock(LocalDatabase.class);
    private final Lifecycle startStopLife = (Lifecycle)Mockito.mock(Lifecycle.class);
    private final StoreFetcher storeFetcher = (StoreFetcher)Mockito.mock(StoreFetcher.class);
    private final CatchUpClient catchUpClient = (CatchUpClient)Mockito.mock(CatchUpClient.class);
    private final CopiedStoreRecovery recovery = (CopiedStoreRecovery)Mockito.mock(CopiedStoreRecovery.class);
    private final CoreState coreState = (CoreState)Mockito.mock(CoreState.class);
    private final NullLogProvider logProvider = NullLogProvider.getInstance();
    private final MemberId remoteMember = new MemberId(UUID.randomUUID());
    private final StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
    private final File storeDir = new File("graph.db");
    private final File tempDir = new File("graph.db/temp-copy");
    private final CoreStateDownloader downloader = new CoreStateDownloader(this.fs, this.localDatabase, this.startStopLife, this.storeFetcher, this.catchUpClient, (LogProvider)this.logProvider, this.recovery);

    @Before
    public void commonMocking() {
        Mockito.when((Object)this.localDatabase.storeId()).thenReturn((Object)this.storeId);
        Mockito.when((Object)this.localDatabase.storeDir()).thenReturn((Object)this.storeDir);
    }

    @Test
    public void shouldDownloadCompleteStoreWhenEmpty() throws Throwable {
        StoreId remoteStoreId = new StoreId(5L, 6L, 7L, 8L);
        Mockito.when((Object)this.storeFetcher.getStoreIdOf(this.remoteMember)).thenReturn((Object)remoteStoreId);
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)true);
        this.downloader.downloadSnapshot(this.remoteMember, this.coreState);
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher, (VerificationMode)Mockito.never())).tryCatchingUp((MemberId)Matchers.any(), (StoreId)Matchers.any(), (File)Matchers.any());
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher)).copyStore(this.remoteMember, remoteStoreId, this.tempDir);
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).replaceWith(this.tempDir);
    }

    @Test
    public void shouldStopDatabaseDuringDownload() throws Throwable {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)true);
        this.downloader.downloadSnapshot(this.remoteMember, this.coreState);
        ((Lifecycle)Mockito.verify((Object)this.startStopLife)).stop();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).stop();
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Lifecycle)Mockito.verify((Object)this.startStopLife)).start();
    }

    @Test
    public void shouldNotOverwriteNonEmptyMismatchingStore() throws Exception {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        StoreId remoteStoreId = new StoreId(5L, 6L, 7L, 8L);
        Mockito.when((Object)this.storeFetcher.getStoreIdOf(this.remoteMember)).thenReturn((Object)remoteStoreId);
        try {
            this.downloader.downloadSnapshot(this.remoteMember, this.coreState);
            Assert.fail();
        }
        catch (StoreCopyFailedException storeCopyFailedException) {
            // empty catch block
        }
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher, (VerificationMode)Mockito.never())).copyStore((MemberId)Matchers.any(), (StoreId)Matchers.any(), (File)Matchers.any());
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher, (VerificationMode)Mockito.never())).tryCatchingUp((MemberId)Matchers.any(), (StoreId)Matchers.any(), (File)Matchers.any());
    }

    @Test
    public void shouldCatchupIfPossible() throws Exception {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.storeFetcher.getStoreIdOf(this.remoteMember)).thenReturn((Object)this.storeId);
        Mockito.when((Object)this.storeFetcher.tryCatchingUp(this.remoteMember, this.storeId, this.storeDir)).thenReturn((Object)CatchupResult.SUCCESS_END_OF_STREAM);
        this.downloader.downloadSnapshot(this.remoteMember, this.coreState);
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher)).tryCatchingUp(this.remoteMember, this.storeId, this.storeDir);
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher, (VerificationMode)Mockito.never())).copyStore((MemberId)Matchers.any(), (StoreId)Matchers.any(), (File)Matchers.any());
    }

    @Test
    public void shouldDownloadWholeStoreIfCannotCatchUp() throws Exception {
        Mockito.when((Object)this.localDatabase.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)this.storeFetcher.getStoreIdOf(this.remoteMember)).thenReturn((Object)this.storeId);
        Mockito.when((Object)this.storeFetcher.tryCatchingUp(this.remoteMember, this.storeId, this.storeDir)).thenReturn((Object)CatchupResult.E_TRANSACTION_PRUNED);
        this.downloader.downloadSnapshot(this.remoteMember, this.coreState);
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher)).tryCatchingUp(this.remoteMember, this.storeId, this.storeDir);
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher)).copyStore(this.remoteMember, this.storeId, this.tempDir);
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).replaceWith(this.tempDir);
    }
}

