/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.machines.tx.ExponentialBackoffStrategy;
import org.neo4j.causalclustering.core.state.machines.tx.RetryStrategy;

public class ExponentialBackoffStrategyTest {
    private static final int NUMBER_OF_ACCESSES = 5;

    @Test
    public void shouldDoubleEachTime() throws Exception {
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, TimeUnit.MILLISECONDS);
        RetryStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i < 5; ++i) {
            timeout.increment();
        }
        Assert.assertEquals((long)32L, (long)timeout.getMillis());
    }

    @Test
    public void shouldProvidePreviousTimeout() throws Exception {
        ExponentialBackoffStrategy strategy = new ExponentialBackoffStrategy(1L, TimeUnit.MILLISECONDS);
        RetryStrategy.Timeout timeout = strategy.newTimeout();
        for (int i = 0; i <= 5; ++i) {
            timeout.increment();
        }
        Assert.assertEquals((long)64L, (long)timeout.getMillis());
    }
}

