/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.TokenRegistry;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.Token;
import org.neo4j.storageengine.api.TokenFactory;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTokenStateMachineTest {
    private final int EXPECTED_TOKEN_ID = 1;
    private final int UNEXPECTED_TOKEN_ID = 1024;

    @Test
    public void shouldCreateTokenId() throws Exception {
        TokenRegistry registry = new TokenRegistry("Label");
        ReplicatedTokenStateMachine stateMachine = new ReplicatedTokenStateMachine(registry, (TokenFactory)new Token.Factory(), (LogProvider)NullLogProvider.getInstance());
        stateMachine.installCommitProcess((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), -1L);
        byte[] commandBytes = ReplicatedTokenRequestSerializer.commandBytes(ReplicatedTokenStateMachineTest.tokenCommands(1));
        stateMachine.applyCommand(new ReplicatedTokenRequest(TokenType.LABEL, "Person", commandBytes), 1L, r -> {});
        Assert.assertEquals((long)1L, (long)registry.getId("Person").intValue());
    }

    @Test
    public void shouldAllocateTokenIdToFirstReplicateRequest() throws Exception {
        TokenRegistry registry = new TokenRegistry("Label");
        ReplicatedTokenStateMachine stateMachine = new ReplicatedTokenStateMachine(registry, (TokenFactory)new Token.Factory(), (LogProvider)NullLogProvider.getInstance());
        stateMachine.installCommitProcess((TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), -1L);
        ReplicatedTokenRequest winningRequest = new ReplicatedTokenRequest(TokenType.LABEL, "Person", ReplicatedTokenRequestSerializer.commandBytes(ReplicatedTokenStateMachineTest.tokenCommands(1)));
        ReplicatedTokenRequest losingRequest = new ReplicatedTokenRequest(TokenType.LABEL, "Person", ReplicatedTokenRequestSerializer.commandBytes(ReplicatedTokenStateMachineTest.tokenCommands(1024)));
        stateMachine.applyCommand(winningRequest, 1L, r -> {});
        stateMachine.applyCommand(losingRequest, 2L, r -> {});
        Assert.assertEquals((long)1L, (long)registry.getId("Person").intValue());
    }

    @Test
    public void shouldStoreRaftLogIndexInTransactionHeader() throws Exception {
        int logIndex = 1;
        StubTransactionCommitProcess commitProcess = new StubTransactionCommitProcess(null, null);
        ReplicatedTokenStateMachine stateMachine = new ReplicatedTokenStateMachine(new TokenRegistry("Token"), (TokenFactory)new Token.Factory(), (LogProvider)NullLogProvider.getInstance());
        stateMachine.installCommitProcess((TransactionCommitProcess)commitProcess, -1L);
        byte[] commandBytes = ReplicatedTokenRequestSerializer.commandBytes(ReplicatedTokenStateMachineTest.tokenCommands(1));
        stateMachine.applyCommand(new ReplicatedTokenRequest(TokenType.LABEL, "Person", commandBytes), (long)logIndex, r -> {});
        List transactions = commitProcess.transactionsToApply;
        Assert.assertEquals((long)1L, (long)transactions.size());
        Assert.assertEquals((long)logIndex, (long)LogIndexTxHeaderEncoding.decodeLogIndexFromTxHeader((byte[])((TransactionRepresentation)transactions.get(0)).additionalHeader()));
    }

    private static List<StorageCommand> tokenCommands(int expectedTokenId) {
        return Collections.singletonList(new Command.LabelTokenCommand(new LabelTokenRecord(expectedTokenId), new LabelTokenRecord(expectedTokenId)));
    }

    private static class StubTransactionCommitProcess
    extends TransactionRepresentationCommitProcess {
        private final List<TransactionRepresentation> transactionsToApply = new ArrayList<TransactionRepresentation>();

        StubTransactionCommitProcess(TransactionAppender appender, StorageEngine storageEngine) {
            super(appender, storageEngine);
        }

        public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
            this.transactionsToApply.add(batch.transactionRepresentation());
            return -1L;
        }
    }
}

