/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocation;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.kernel.impl.store.IdGeneratorContractTest;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ReplicatedIdGeneratorTest
extends IdGeneratorContractTest {
    private NullLogProvider logProvider = NullLogProvider.getInstance();

    protected IdGenerator createIdGenerator(int grabSize) {
        return this.openIdGenerator(grabSize);
    }

    protected IdGenerator openIdGenerator(int grabSize) {
        return new ReplicatedIdGenerator(IdType.NODE, 0L, this.stubAcquirer(), (LogProvider)this.logProvider);
    }

    @Test
    public void shouldNotStepBeyondAllocationBoundaryWithoutBurnedId() throws Exception {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        ReplicatedIdGenerator idGenerator = new ReplicatedIdGenerator(IdType.NODE, 0L, rangeAcquirer, (LogProvider)this.logProvider);
        Set<Long> idsGenerated = this.collectGeneratedIds(idGenerator, 1024);
        long minId = Collections.min(idsGenerated);
        long maxId = Collections.max(idsGenerated);
        Assert.assertEquals((long)0L, (long)minId);
        Assert.assertEquals((long)1023L, (long)maxId);
    }

    @Test
    public void shouldNotStepBeyondAllocationBoundaryWithBurnedId() throws Exception {
        ReplicatedIdRangeAcquirer rangeAcquirer = this.simpleRangeAcquirer(IdType.NODE, 0L, 1024);
        int burnedIds = 23;
        ReplicatedIdGenerator idGenerator = new ReplicatedIdGenerator(IdType.NODE, (long)burnedIds, rangeAcquirer, (LogProvider)this.logProvider);
        Set<Long> idsGenerated = this.collectGeneratedIds(idGenerator, 1024 - burnedIds);
        long minId = Collections.min(idsGenerated);
        long maxId = Collections.max(idsGenerated);
        Assert.assertEquals((long)burnedIds, (long)minId);
        Assert.assertEquals((long)1023L, (long)maxId);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIfAdjustmentFailsDueToInconsistentValues() throws Exception {
        ReplicatedIdRangeAcquirer rangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);
        Mockito.when((Object)rangeAcquirer.acquireIds(IdType.NODE)).thenReturn((Object)this.allocation(3L, 21, 21));
        ReplicatedIdGenerator idGenerator = new ReplicatedIdGenerator(IdType.NODE, 42L, rangeAcquirer, (LogProvider)this.logProvider);
        idGenerator.nextId();
    }

    private Set<Long> collectGeneratedIds(ReplicatedIdGenerator idGenerator, int expectedIds) {
        HashSet<Long> idsGenerated = new HashSet<Long>();
        for (int i = 0; i < expectedIds; ++i) {
            long nextId = idGenerator.nextId();
            Assert.assertThat((Object)nextId, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
            idsGenerated.add(nextId);
        }
        try {
            idGenerator.nextId();
            Assert.fail((String)("Too many ids produced, expected " + expectedIds));
        }
        catch (NoMoreIds noMoreIds) {
            // empty catch block
        }
        return idsGenerated;
    }

    private ReplicatedIdRangeAcquirer simpleRangeAcquirer(IdType idType, long start, int length) {
        ReplicatedIdRangeAcquirer rangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);
        Mockito.when((Object)rangeAcquirer.acquireIds(idType)).thenReturn((Object)this.allocation(start, length, -1)).thenThrow(new Class[]{NoMoreIds.class});
        return rangeAcquirer;
    }

    private IdAllocation allocation(long start, int length, int highestIdInUse) {
        return new IdAllocation(new IdRange(new long[0], start, length), (long)highestIdInUse, 0L);
    }

    private ReplicatedIdRangeAcquirer stubAcquirer() {
        ReplicatedIdRangeAcquirer rangeAcquirer = (ReplicatedIdRangeAcquirer)Mockito.mock(ReplicatedIdRangeAcquirer.class);
        Mockito.when((Object)rangeAcquirer.acquireIds(IdType.NODE)).thenReturn((Object)this.allocation(0L, 1024, -1)).thenReturn((Object)this.allocation(1024L, 1024, 1023)).thenReturn((Object)this.allocation(2048L, 1024, 2047)).thenReturn((Object)this.allocation(3072L, 1024, 3071)).thenReturn((Object)this.allocation(4096L, 1024, 4095)).thenReturn((Object)this.allocation(5120L, 1024, 5119)).thenReturn((Object)this.allocation(6144L, 1024, 6143)).thenReturn((Object)this.allocation(7168L, 1024, 7167)).thenReturn((Object)this.allocation(8192L, 1024, 8191)).thenReturn((Object)this.allocation(9216L, 1024, 9215)).thenReturn((Object)this.allocation(-1L, 0, 10240));
        return rangeAcquirer;
    }

    private static class NoMoreIds
    extends RuntimeException {
        private NoMoreIds() {
        }
    }
}

