/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.machines.id.IdRangeIterator;
import org.neo4j.kernel.impl.store.id.IdRange;

public class IdRangeIteratorTest {
    @Test
    public void shouldReturnValueRepresentingNullIfWeExhaustIdRange() throws Exception {
        int rangeLength = 1024;
        IdRangeIterator iterator = new IdRangeIterator(new IdRange(new long[0], 0L, rangeLength));
        for (int i = 0; i < rangeLength; ++i) {
            iterator.next();
        }
        Assert.assertEquals((long)-1L, (long)iterator.next());
    }

    @Test
    public void shouldNotHaveAnyGaps() throws Exception {
        int rangeLength = 1024;
        IdRangeIterator iterator = new IdRangeIterator(new IdRange(new long[0], 0L, rangeLength));
        HashSet<Long> seenIds = new HashSet<Long>();
        for (int i = 0; i < rangeLength; ++i) {
            seenIds.add(iterator.next());
            if (i <= 0) continue;
            Assert.assertTrue((String)("Missing id " + (i - 1)), (boolean)seenIds.contains((long)i - 1L));
        }
    }

    @Test
    public void shouldUseDefragIdsFirst() throws Exception {
        int rangeLength = 1024;
        IdRangeIterator iterator = new IdRangeIterator(new IdRange(new long[]{7L, 8L, 9L}, 1024L, rangeLength));
        Assert.assertEquals((long)7L, (long)iterator.next());
        Assert.assertEquals((long)8L, (long)iterator.next());
        Assert.assertEquals((long)9L, (long)iterator.next());
        Assert.assertEquals((long)1024L, (long)iterator.next());
    }
}

