/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines;

import java.util.function.Consumer;
import junit.framework.TestCase;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.machines.StateMachine;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.TokenType;
import org.neo4j.causalclustering.core.state.machines.tx.RecoverTransactionLogState;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionStateMachine;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.storageengine.api.Token;

public class CoreStateMachinesTest {
    private final ReplicatedTransactionStateMachine txSM = (ReplicatedTransactionStateMachine)Mockito.mock(ReplicatedTransactionStateMachine.class);
    private final ReplicatedTokenStateMachine<Token> labelTokenSM = (ReplicatedTokenStateMachine)Mockito.mock(ReplicatedTokenStateMachine.class);
    private final ReplicatedTokenStateMachine<RelationshipTypeToken> relationshipTypeTokenSM = (ReplicatedTokenStateMachine)Mockito.mock(ReplicatedTokenStateMachine.class);
    private final ReplicatedTokenStateMachine<Token> propertyKeyTokenSM = (ReplicatedTokenStateMachine)Mockito.mock(ReplicatedTokenStateMachine.class);
    private final ReplicatedLockTokenStateMachine lockTokenSM = (ReplicatedLockTokenStateMachine)Mockito.mock(ReplicatedLockTokenStateMachine.class);
    private final ReplicatedIdAllocationStateMachine idAllocationSM = (ReplicatedIdAllocationStateMachine)Mockito.mock(ReplicatedIdAllocationStateMachine.class);
    private final RecoverTransactionLogState recoverTransactionLogState = (RecoverTransactionLogState)Mockito.mock(RecoverTransactionLogState.class);
    private final CoreStateMachines coreStateMachines = new CoreStateMachines(this.txSM, this.labelTokenSM, this.relationshipTypeTokenSM, this.propertyKeyTokenSM, this.lockTokenSM, this.idAllocationSM, this.recoverTransactionLogState, (LocalDatabase)Mockito.mock(LocalDatabase.class));
    private final ReplicatedTransaction replicatedTransaction = (ReplicatedTransaction)Mockito.mock(ReplicatedTransaction.class);
    private final ReplicatedIdAllocationRequest iAllocationRequest = (ReplicatedIdAllocationRequest)Mockito.mock(ReplicatedIdAllocationRequest.class);
    private final ReplicatedTokenRequest relationshipTypeTokenRequest = (ReplicatedTokenRequest)Mockito.mock(ReplicatedTokenRequest.class);
    private final ReplicatedLockTokenRequest lockTokenRequest;
    private final Consumer<Result> callback;
    private final InOrder verifier;

    public CoreStateMachinesTest() {
        Mockito.when((Object)this.relationshipTypeTokenRequest.type()).thenReturn((Object)TokenType.RELATIONSHIP);
        this.lockTokenRequest = (ReplicatedLockTokenRequest)Mockito.mock(ReplicatedLockTokenRequest.class);
        this.callback = (Consumer)Mockito.mock(Consumer.class);
        this.verifier = Mockito.inOrder((Object[])new Object[]{this.txSM, this.labelTokenSM, this.relationshipTypeTokenSM, this.propertyKeyTokenSM, this.lockTokenSM, this.idAllocationSM});
    }

    @Test
    public void shouldAllowForBatchingOfTransactions() throws Exception {
        try (CommandDispatcher dispatcher = this.coreStateMachines.commandDispatcher();){
            dispatcher.dispatch(this.replicatedTransaction, 0L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 1L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 2L, this.callback);
        }
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 0L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 1L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 2L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).ensuredApplied();
        this.verifier.verifyNoMoreInteractions();
    }

    @Test
    public void shouldApplyTransactionBatchAsSoonAsThereIsADifferentKindOfRequestInTheBatch() throws Exception {
        try (CommandDispatcher dispatcher = this.coreStateMachines.commandDispatcher();){
            dispatcher.dispatch(this.replicatedTransaction, 0L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 1L, this.callback);
            dispatcher.dispatch(this.iAllocationRequest, 2L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 3L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 4L, this.callback);
            dispatcher.dispatch(this.relationshipTypeTokenRequest, 5L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 6L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 7L, this.callback);
            dispatcher.dispatch(this.lockTokenRequest, 8L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 9L, this.callback);
            dispatcher.dispatch(this.replicatedTransaction, 10L, this.callback);
        }
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 0L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 1L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).ensuredApplied();
        ((ReplicatedIdAllocationStateMachine)this.verifier.verify((Object)this.idAllocationSM)).applyCommand(this.iAllocationRequest, 2L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 3L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 4L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).ensuredApplied();
        ((ReplicatedTokenStateMachine)this.verifier.verify(this.relationshipTypeTokenSM)).applyCommand(this.relationshipTypeTokenRequest, 5L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 6L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 7L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).ensuredApplied();
        ((ReplicatedLockTokenStateMachine)this.verifier.verify((Object)this.lockTokenSM)).applyCommand(this.lockTokenRequest, 8L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 9L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).applyCommand(this.replicatedTransaction, 10L, this.callback);
        ((ReplicatedTransactionStateMachine)this.verifier.verify((Object)this.txSM)).ensuredApplied();
        this.verifier.verifyNoMoreInteractions();
    }

    @Test
    public void shouldReturnLastAppliedOfAllStateMachines() throws Exception {
        StateMachine[] txSMs = new StateMachine[]{this.labelTokenSM, this.relationshipTypeTokenSM, this.propertyKeyTokenSM, this.txSM};
        StateMachine[] otherSMs = new StateMachine[]{this.idAllocationSM, this.lockTokenSM};
        int totalDistinctSMs = otherSMs.length + 1;
        for (long base = 0L; base < (long)totalDistinctSMs; ++base) {
            long lastAppliedIndex;
            long expected = -1L;
            long index = 0L;
            for (StateMachine sm : otherSMs) {
                lastAppliedIndex = (base + index) % (long)totalDistinctSMs;
                expected = Math.max(expected, lastAppliedIndex);
                Mockito.when((Object)sm.lastAppliedIndex()).thenReturn((Object)lastAppliedIndex);
                ++index;
            }
            lastAppliedIndex = (base + index) % (long)totalDistinctSMs;
            for (StateMachine sm : txSMs) {
                Mockito.when((Object)sm.lastAppliedIndex()).thenReturn((Object)lastAppliedIndex);
            }
            TestCase.assertEquals((long)expected, (long)this.coreStateMachines.getLastAppliedIndex());
        }
    }
}

