/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.state.InFlightLogEntryReader;

@RunWith(value=Parameterized.class)
public class InFlightLogEntryReaderTest {
    private final ReadableRaftLog raftLog = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
    private final InFlightMap<RaftLogEntry> inFlightMap = (InFlightMap)Mockito.mock(InFlightMap.class);
    private final long logIndex = 42L;
    private final RaftLogEntry entry = (RaftLogEntry)Mockito.mock(RaftLogEntry.class);
    @Parameterized.Parameter(value=0)
    public boolean clearCache;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Boolean[]> params() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void shouldUseTheCacheWhenTheIndexIsPresent() throws Exception {
        InFlightLogEntryReader reader = new InFlightLogEntryReader(this.raftLog, this.inFlightMap, this.clearCache);
        this.startingFromIndexReturnEntries(this.inFlightMap, 42L, this.entry, new RaftLogEntry[0]);
        this.startingFromIndexReturnEntries(this.raftLog, -1L, null, new RaftLogEntry[0]);
        RaftLogEntry raftLogEntry = reader.get(42L);
        Assert.assertEquals((Object)this.entry, (Object)raftLogEntry);
        ((InFlightMap)Mockito.verify(this.inFlightMap)).get(Long.valueOf(42L));
        this.assertCacheIsUpdated(this.inFlightMap, 42L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.inFlightMap});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.raftLog});
    }

    @Test
    public void shouldUseTheRaftLogWhenTheIndexIsNotPresent() throws Exception {
        InFlightLogEntryReader reader = new InFlightLogEntryReader(this.raftLog, this.inFlightMap, this.clearCache);
        this.startingFromIndexReturnEntries(this.inFlightMap, 42L, null, new RaftLogEntry[0]);
        this.startingFromIndexReturnEntries(this.raftLog, 42L, this.entry, new RaftLogEntry[0]);
        RaftLogEntry raftLogEntry = reader.get(42L);
        Assert.assertEquals((Object)this.entry, (Object)raftLogEntry);
        ((InFlightMap)Mockito.verify(this.inFlightMap)).get(Long.valueOf(42L));
        ((ReadableRaftLog)Mockito.verify((Object)this.raftLog)).getEntryCursor(42L);
        this.assertCacheIsUpdated(this.inFlightMap, 42L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.inFlightMap});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.raftLog});
    }

    @Test
    public void shouldNeverUseMapAgainAfterHavingFeltBackToTheRaftLog() throws Exception {
        InFlightLogEntryReader reader = new InFlightLogEntryReader(this.raftLog, this.inFlightMap, this.clearCache);
        this.startingFromIndexReturnEntries(this.inFlightMap, 42L, this.entry, null, (RaftLogEntry)Mockito.mock(RaftLogEntry.class));
        RaftLogEntry[] entries = new RaftLogEntry[]{this.entry, (RaftLogEntry)Mockito.mock(RaftLogEntry.class), (RaftLogEntry)Mockito.mock(RaftLogEntry.class)};
        this.startingFromIndexReturnEntries(this.raftLog, 43L, entries[1], entries[2]);
        for (int offset = 0; offset < 3; ++offset) {
            RaftLogEntry raftLogEntry = reader.get((long)offset + 42L);
            Assert.assertEquals((Object)entries[offset], (Object)raftLogEntry);
            if (offset <= 1) {
                ((InFlightMap)Mockito.verify(this.inFlightMap)).get(Long.valueOf((long)offset + 42L));
            }
            if (offset == 1) {
                ((ReadableRaftLog)Mockito.verify((Object)this.raftLog)).getEntryCursor((long)offset + 42L);
            }
            this.assertCacheIsUpdated(this.inFlightMap, (long)offset + 42L);
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.inFlightMap});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.raftLog});
    }

    private void startingFromIndexReturnEntries(InFlightMap<RaftLogEntry> inFlightMap, long startIndex, RaftLogEntry entry, RaftLogEntry ... otherEntries) throws IOException {
        Mockito.when((Object)inFlightMap.get(Long.valueOf(startIndex))).thenReturn((Object)entry);
        for (int offset = 0; offset < otherEntries.length; ++offset) {
            Mockito.when((Object)inFlightMap.get(Long.valueOf(startIndex + (long)offset + 1L))).thenReturn((Object)otherEntries[offset]);
        }
    }

    private void startingFromIndexReturnEntries(ReadableRaftLog raftLog, long startIndex, RaftLogEntry entry, RaftLogEntry ... otherEntries) throws IOException {
        RaftLogCursor cursor = (RaftLogCursor)Mockito.mock(RaftLogCursor.class);
        Mockito.when((Object)raftLog.getEntryCursor(startIndex)).thenReturn((Object)cursor, (Object[])new RaftLogCursor[]{null});
        Object[] bools = new Boolean[otherEntries.length + 1];
        Arrays.fill(bools, Boolean.TRUE);
        bools[otherEntries.length] = Boolean.FALSE;
        Mockito.when((Object)cursor.next()).thenReturn((Object)true, bools);
        Object[] indexes = new Long[otherEntries.length + 1];
        for (int offset = 0; offset < indexes.length; ++offset) {
            indexes[offset] = startIndex + 1L + (long)offset;
        }
        indexes[otherEntries.length] = -1L;
        Mockito.when((Object)cursor.index()).thenReturn((Object)startIndex, indexes);
        Object[] raftLogEntries = Arrays.copyOf(otherEntries, otherEntries.length + 1);
        Mockito.when((Object)cursor.get()).thenReturn((Object)entry, raftLogEntries);
    }

    public void assertCacheIsUpdated(InFlightMap<RaftLogEntry> inFlightMap, long key) {
        if (this.clearCache) {
            ((InFlightMap)Mockito.verify(inFlightMap, (VerificationMode)Mockito.times((int)1))).remove(Long.valueOf(key));
        } else {
            ((InFlightMap)Mockito.verify(inFlightMap, (VerificationMode)Mockito.never())).remove(Long.valueOf(key));
        }
    }
}

