/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipState;
import org.neo4j.causalclustering.core.consensus.term.TermState;
import org.neo4j.causalclustering.core.consensus.vote.VoteState;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.DumpClusterState;
import org.neo4j.causalclustering.core.state.LongIndexMarshal;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.storage.DurableStateStorage;
import org.neo4j.causalclustering.core.state.storage.SimpleFileStorage;
import org.neo4j.causalclustering.core.state.storage.StateMarshal;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class DumpClusterStateTest {
    @Rule
    public EphemeralFileSystemRule fsa = new EphemeralFileSystemRule();
    private File clusterStateDirectory = new File("cluster-state");

    @Test
    public void shouldDumpClusterState() throws Exception {
        this.createStates();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DumpClusterState dumpTool = new DumpClusterState((FileSystemAbstraction)this.fsa.get(), this.clusterStateDirectory, new PrintStream(out));
        dumpTool.dump();
        int lineCount = out.toString().split(System.lineSeparator()).length;
        Assert.assertEquals((long)8L, (long)lineCount);
    }

    private void createStates() throws IOException {
        SimpleFileStorage memberIdStorage = new SimpleFileStorage((FileSystemAbstraction)this.fsa.get(), this.clusterStateDirectory, "core-member-id", (ChannelMarshal)new MemberId.Marshal(), (LogProvider)NullLogProvider.getInstance());
        memberIdStorage.writeState((Object)new MemberId(UUID.randomUUID()));
        this.createDurableState("last-flushed", (StateMarshal)new LongIndexMarshal());
        this.createDurableState("lock-token", (StateMarshal)new ReplicatedLockTokenState.Marshal((ChannelMarshal)new MemberId.Marshal()));
        this.createDurableState("id-allocation", (StateMarshal)new IdAllocationState.Marshal());
        this.createDurableState("session-tracker", (StateMarshal)new GlobalSessionTrackerState.Marshal((ChannelMarshal)new MemberId.Marshal()));
        this.createDurableState("membership", (StateMarshal)new RaftMembershipState.Marshal());
        this.createDurableState("term", (StateMarshal)new TermState.Marshal());
        this.createDurableState("vote", (StateMarshal)new VoteState.Marshal((ChannelMarshal)new MemberId.Marshal()));
    }

    private <T> void createDurableState(String name, StateMarshal<T> marshal) throws IOException {
        DurableStateStorage storage = new DurableStateStorage((FileSystemAbstraction)this.fsa.get(), this.clusterStateDirectory, name, marshal, 1024, (LogProvider)NullLogProvider.getInstance());
        Lifespan ignored = new Lifespan(new Lifecycle[]{storage});
        Throwable throwable = null;
        if (ignored != null) {
            if (throwable != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ignored.close();
            }
        }
    }
}

