/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.state.CoreStateApplier;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CoreStateApplierTest {
    @Test
    public void shouldBeAbortable() throws Exception {
        CoreStateApplier applier = new CoreStateApplier((LogProvider)NullLogProvider.getInstance());
        CountDownLatch latch = new CountDownLatch(1);
        applier.submit(status -> () -> {
            while (!status.isCancelled()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            latch.countDown();
        });
        applier.sync(true);
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }
}

