/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.backup.RestoreClusterUtils;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.tx.LastCommittedIndexFinder;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.ReadOnlyTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class CoreBootstrapperTest {
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.pageCacheRule).around((TestRule)this.pageCacheRule).around((TestRule)this.testDirectory);

    @Test
    public void shouldSetAllCoreState() throws Exception {
        int nodeCount = 100;
        DefaultFileSystemAbstraction fileSystem = this.fileSystemRule.get();
        File classicNeo4jStore = RestoreClusterUtils.createClassicNeo4jStore(this.testDirectory.directory(), (FileSystemAbstraction)fileSystem, nodeCount, "standard");
        PageCache pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)fileSystem);
        CoreBootstrapper bootstrapper = new CoreBootstrapper(classicNeo4jStore, pageCache, (FileSystemAbstraction)fileSystem, Config.defaults(), (LogProvider)NullLogProvider.getInstance());
        Set membership = Iterators.asSet((Object[])new MemberId[]{this.randomMember(), this.randomMember(), this.randomMember()});
        CoreSnapshot snapshot = bootstrapper.bootstrap(membership);
        Assert.assertEquals((long)nodeCount, (long)((IdAllocationState)snapshot.get(CoreStateType.ID_ALLOCATION)).firstUnallocated(IdType.NODE));
        Assert.assertEquals((long)0L, (long)snapshot.prevIndex());
        Assert.assertEquals((long)0L, (long)snapshot.prevTerm());
        Assert.assertEquals((Object)new ReplicatedLockTokenState(), (Object)snapshot.get(CoreStateType.LOCK_TOKEN));
        Assert.assertEquals((Object)membership, (Object)((RaftCoreState)snapshot.get(CoreStateType.RAFT_CORE_STATE)).committed().members());
        Assert.assertEquals((Object)new GlobalSessionTrackerState(), (Object)snapshot.get(CoreStateType.SESSION_TRACKER));
        LastCommittedIndexFinder lastCommittedIndexFinder = new LastCommittedIndexFinder((TransactionIdStore)new ReadOnlyTransactionIdStore(pageCache, classicNeo4jStore), (LogicalTransactionStore)new ReadOnlyTransactionStore(pageCache, (FileSystemAbstraction)fileSystem, classicNeo4jStore, new Monitors()), (LogProvider)NullLogProvider.getInstance());
        long lastCommittedIndex = lastCommittedIndexFinder.getLastCommittedIndex();
        Assert.assertEquals((long)-1L, (long)lastCommittedIndex);
    }

    private MemberId randomMember() {
        return new MemberId(UUID.randomUUID());
    }
}

