/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.util.Arrays;
import java.util.UUID;
import java.util.function.Consumer;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.SessionTracker;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftLogCommitIndexMonitor;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.ProgressTrackerImpl;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.GlobalSessionTrackerState;
import org.neo4j.causalclustering.core.replication.session.LocalOperationId;
import org.neo4j.causalclustering.core.state.CommandApplicationProcess;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.CoreStateApplier;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.CoreStateMachines;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.storage.InMemoryStateStorage;
import org.neo4j.causalclustering.core.state.storage.StateStorage;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CommandApplicationProcessTest {
    private final InMemoryRaftLog raftLog = (InMemoryRaftLog)Mockito.spy((Object)new InMemoryRaftLog());
    private final InMemoryStateStorage<Long> lastFlushedStorage = new InMemoryStateStorage((Object)-1L);
    private final SessionTracker sessionStorage = new SessionTracker((StateStorage)new InMemoryStateStorage((Object)new GlobalSessionTrackerState()));
    private final DatabaseHealth dbHealth = new DatabaseHealth((DatabasePanicEventGenerator)Mockito.mock(DatabasePanicEventGenerator.class), NullLogProvider.getInstance().getLog(this.getClass()));
    private final GlobalSession globalSession = new GlobalSession(UUID.randomUUID(), null);
    private final int flushEvery = 10;
    private final int batchSize = 16;
    private final CoreStateApplier applier = new CoreStateApplier((LogProvider)NullLogProvider.getInstance());
    private InFlightMap<RaftLogEntry> inFlightMap = (InFlightMap)Mockito.spy((Object)new InFlightMap());
    private final Monitors monitors = new Monitors();
    private final CoreStateMachines coreStateMachines = (CoreStateMachines)Mockito.mock(CoreStateMachines.class);
    private final CommandApplicationProcess applicationProcess = new CommandApplicationProcess(this.coreStateMachines, (RaftLog)this.raftLog, 16, 10, () -> this.dbHealth, (LogProvider)NullLogProvider.getInstance(), (ProgressTracker)new ProgressTrackerImpl(this.globalSession), this.lastFlushedStorage, this.sessionStorage, this.applier, this.inFlightMap, this.monitors);
    private ReplicatedTransaction nullTx = new ReplicatedTransaction(null);
    private final CommandDispatcher commandDispatcher = (CommandDispatcher)Mockito.mock(CommandDispatcher.class);
    private int sequenceNumber;

    public CommandApplicationProcessTest() {
        Mockito.when((Object)this.coreStateMachines.commandDispatcher()).thenReturn((Object)this.commandDispatcher);
        Mockito.when((Object)this.coreStateMachines.getLastAppliedIndex()).thenReturn((Object)-1L);
        this.sequenceNumber = 0;
    }

    private ReplicatedTransaction tx(byte dataValue) {
        byte[] dataArray = new byte[30];
        Arrays.fill(dataArray, dataValue);
        return new ReplicatedTransaction(dataArray);
    }

    private synchronized ReplicatedContent operation(CoreReplicatedContent tx) {
        return new DistributedOperation((ReplicatedContent)tx, this.globalSession, new LocalOperationId(0L, (long)this.sequenceNumber++));
    }

    @Test
    public void shouldApplyCommittedCommand() throws Throwable {
        RaftLogCommitIndexMonitor listener = (RaftLogCommitIndexMonitor)Mockito.mock(RaftLogCommitIndexMonitor.class);
        this.monitors.addMonitorListener((Object)listener, new String[0]);
        this.applicationProcess.start();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreStateMachines, this.commandDispatcher});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(2L);
        this.applier.sync(false);
        ((CoreStateMachines)inOrder.verify((Object)this.coreStateMachines)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)0L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)2L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
        ((RaftLogCommitIndexMonitor)Mockito.verify((Object)listener)).commitIndex(2L);
    }

    @Test
    public void shouldNotApplyUncommittedCommands() throws Throwable {
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(-1L);
        this.applier.sync(false);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.commandDispatcher});
    }

    @Test
    public void entriesThatAreNotStateMachineCommandsShouldStillIncreaseCommandIndex() throws Throwable {
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(1L);
        this.applier.sync(false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreStateMachines, this.commandDispatcher});
        ((CoreStateMachines)inOrder.verify((Object)this.coreStateMachines)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
    }

    @Test
    public void duplicatesShouldBeIgnoredButStillIncreaseCommandIndex() throws Exception {
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.nullTx, this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.nullTx, this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.nullTx, this.globalSession, new LocalOperationId(0L, 1L)))});
        this.applicationProcess.notifyCommitted(3L);
        this.applier.sync(false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreStateMachines, this.commandDispatcher});
        ((CoreStateMachines)inOrder.verify((Object)this.coreStateMachines)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)3L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.commandDispatcher});
    }

    @Test
    public void outOfOrderDuplicatesShouldBeIgnoredButStillIncreaseCommandIndex() throws Exception {
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)100), this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)101), this.globalSession, new LocalOperationId(0L, 1L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)102), this.globalSession, new LocalOperationId(0L, 2L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)101), this.globalSession, new LocalOperationId(0L, 1L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)100), this.globalSession, new LocalOperationId(0L, 0L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)103), this.globalSession, new LocalOperationId(0L, 3L)))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new DistributedOperation((ReplicatedContent)this.tx((byte)104), this.globalSession, new LocalOperationId(0L, 4L)))});
        this.applicationProcess.notifyCommitted(6L);
        this.applier.sync(false);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.coreStateMachines, this.commandDispatcher});
        ((CoreStateMachines)inOrder.verify((Object)this.coreStateMachines)).commandDispatcher();
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.tx((byte)100)), Matchers.eq((long)0L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.tx((byte)101)), Matchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.tx((byte)102)), Matchers.eq((long)2L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.tx((byte)103)), Matchers.eq((long)5L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.tx((byte)104)), Matchers.eq((long)6L), this.anyCallback());
        ((CommandDispatcher)inOrder.verify((Object)this.commandDispatcher)).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.commandDispatcher});
    }

    @Test
    public void shouldPeriodicallyFlushState() throws Throwable {
        this.applicationProcess.start();
        int interactions = 50;
        for (int i = 0; i < interactions; ++i) {
            this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        }
        this.applicationProcess.notifyCommitted((long)interactions);
        this.applier.sync(false);
        ((CoreStateMachines)Mockito.verify((Object)this.coreStateMachines, (VerificationMode)Mockito.times((int)(interactions / 16)))).flush();
        TestCase.assertEquals((long)(interactions - interactions % 16 - 1), (long)((Long)this.lastFlushedStorage.getInitialState()));
    }

    @Test
    public void shouldPanicIfUnableToApply() throws Throwable {
        ((CommandDispatcher)Mockito.doThrow(IllegalStateException.class).when((Object)this.commandDispatcher)).dispatch((ReplicatedTransaction)Matchers.any(ReplicatedTransaction.class), Matchers.anyLong(), this.anyCallback());
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        TestCase.assertEquals((boolean)true, (boolean)this.dbHealth.isHealthy());
        this.applicationProcess.notifyCommitted(0L);
        this.applier.sync(false);
        TestCase.assertEquals((boolean)false, (boolean)this.dbHealth.isHealthy());
    }

    @Test
    public void shouldApplyToLogFromCache() throws Throwable {
        this.applicationProcess.start();
        this.inFlightMap.put(Long.valueOf(0L), (Object)new RaftLogEntry(1L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.applicationProcess.notifyCommitted(0L);
        this.applier.sync(false);
        ((InFlightMap)Mockito.verify(this.inFlightMap, (VerificationMode)Mockito.times((int)1))).get(Long.valueOf(0L));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.raftLog});
    }

    @Test
    public void cacheEntryShouldBePurgedWhenApplied() throws Throwable {
        this.applicationProcess.start();
        this.inFlightMap.put(Long.valueOf(0L), (Object)new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.inFlightMap.put(Long.valueOf(1L), (Object)new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.inFlightMap.put(Long.valueOf(2L), (Object)new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.applicationProcess.notifyCommitted(0L);
        this.applier.sync(false);
        Assert.assertNull((Object)this.inFlightMap.get(Long.valueOf(0L)));
        Assert.assertNotNull((Object)this.inFlightMap.get(Long.valueOf(1L)));
        Assert.assertNotNull((Object)this.inFlightMap.get(Long.valueOf(2L)));
    }

    @Test
    public void shouldFallbackToLogCursorOnCacheMiss() throws Throwable {
        this.applicationProcess.start();
        ReplicatedContent operation0 = this.operation((CoreReplicatedContent)this.nullTx);
        ReplicatedContent operation1 = this.operation((CoreReplicatedContent)this.nullTx);
        ReplicatedContent operation2 = this.operation((CoreReplicatedContent)this.nullTx);
        this.inFlightMap.put(Long.valueOf(0L), (Object)new RaftLogEntry(0L, operation0));
        this.inFlightMap.put(Long.valueOf(2L), (Object)new RaftLogEntry(2L, operation2));
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, operation0)});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, operation1)});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(2L, operation2)});
        this.applicationProcess.notifyCommitted(2L);
        this.applier.sync(false);
        ((InFlightMap)Mockito.verify(this.inFlightMap, (VerificationMode)Mockito.times((int)1))).get(Long.valueOf(0L));
        ((InFlightMap)Mockito.verify(this.inFlightMap, (VerificationMode)Mockito.times((int)1))).get(Long.valueOf(1L));
        ((InFlightMap)Mockito.verify(this.inFlightMap, (VerificationMode)Mockito.times((int)0))).get(Long.valueOf(2L));
        ((InFlightMap)Mockito.verify(this.inFlightMap, (VerificationMode)Mockito.times((int)1))).remove(Long.valueOf(0L));
        ((CommandDispatcher)Mockito.verify((Object)this.commandDispatcher, (VerificationMode)Mockito.times((int)1))).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)0L), this.anyCallback());
        ((CommandDispatcher)Mockito.verify((Object)this.commandDispatcher, (VerificationMode)Mockito.times((int)1))).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)1L), this.anyCallback());
        ((CommandDispatcher)Mockito.verify((Object)this.commandDispatcher, (VerificationMode)Mockito.times((int)1))).dispatch((ReplicatedTransaction)Matchers.eq((Object)this.nullTx), Matchers.eq((long)2L), this.anyCallback());
        ((InMemoryRaftLog)Mockito.verify((Object)this.raftLog, (VerificationMode)Mockito.times((int)1))).getEntryCursor(1L);
    }

    @Test
    public void shouldFailWhenCacheAndLogMiss() throws Throwable {
        this.applicationProcess.start();
        this.inFlightMap.put(Long.valueOf(0L), (Object)new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx)));
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(1L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(2L);
        this.applier.sync(false);
        Assert.assertFalse((boolean)this.dbHealth.isHealthy());
    }

    @Test
    public void shouldIncreaseLastAppliedForStateMachineCommands() throws Exception {
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, this.operation((CoreReplicatedContent)this.nullTx))});
        this.applicationProcess.notifyCommitted(2L);
        this.applier.sync(false);
        TestCase.assertEquals((long)2L, (long)this.applicationProcess.lastApplied());
    }

    @Test
    public void shouldIncreaseLastAppliedForOtherCommands() throws Exception {
        this.applicationProcess.start();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new NewLeaderBarrier())});
        this.applicationProcess.notifyCommitted(2L);
        this.applier.sync(false);
        TestCase.assertEquals((long)2L, (long)this.applicationProcess.lastApplied());
    }

    private Consumer<Result> anyCallback() {
        Consumer anyCallback = (Consumer)Matchers.any(Consumer.class);
        return anyCallback;
    }
}

