/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.replication;

import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.Progress;
import org.neo4j.causalclustering.core.replication.ProgressTracker;
import org.neo4j.causalclustering.core.replication.RaftReplicator;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.replication.session.GlobalSession;
import org.neo4j.causalclustering.core.replication.session.LocalSessionPool;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.tx.ConstantTimeRetryStrategy;
import org.neo4j.causalclustering.core.state.machines.tx.RetryStrategy;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.test.assertion.Assert;

public class RaftReplicatorTest {
    private static final int DEFAULT_TIMEOUT_MS = 15000;
    private LeaderLocator leaderLocator = (LeaderLocator)Mockito.mock(LeaderLocator.class);
    private MemberId myself = new MemberId(UUID.randomUUID());
    private MemberId leader = new MemberId(UUID.randomUUID());
    private GlobalSession session = new GlobalSession(UUID.randomUUID(), this.myself);
    private LocalSessionPool sessionPool = new LocalSessionPool(this.session);
    private RetryStrategy retryStrategy = new ConstantTimeRetryStrategy(1L, TimeUnit.SECONDS);

    @Test
    public void shouldSendReplicatedContentToLeader() throws Exception {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.retryStrategy);
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        Thread replicatingThread = this.replicatingThread(replicator, content, false);
        replicatingThread.start();
        Assert.assertEventually((String)"making progress", () -> capturedProgress.last, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        capturedProgress.last.setReplicated();
        replicatingThread.join(15000L);
        TestCase.assertEquals((Object)this.leader, (Object)outbound.lastTo);
    }

    @Test
    public void shouldResendAfterTimeout() throws Exception {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        ConstantTimeRetryStrategy retryStrategy = new ConstantTimeRetryStrategy(100L, TimeUnit.MILLISECONDS);
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, (RetryStrategy)retryStrategy);
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        Thread replicatingThread = this.replicatingThread(replicator, content, false);
        replicatingThread.start();
        Assert.assertEventually((String)"send count", () -> outbound.count, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(2)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        capturedProgress.last.setReplicated();
        replicatingThread.join(15000L);
    }

    @Test
    public void shouldReleaseSessionWhenFinished() throws Exception {
        Mockito.when((Object)this.leaderLocator.getLeader()).thenReturn((Object)this.leader);
        CapturingProgressTracker capturedProgress = new CapturingProgressTracker();
        CapturingOutbound outbound = new CapturingOutbound();
        RaftReplicator replicator = new RaftReplicator(this.leaderLocator, this.myself, outbound, this.sessionPool, (ProgressTracker)capturedProgress, this.retryStrategy);
        ReplicatedInteger content = ReplicatedInteger.valueOf(5);
        Thread replicatingThread = this.replicatingThread(replicator, content, true);
        replicatingThread.start();
        Assert.assertEventually((String)"making progress", () -> capturedProgress.last, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.equalTo(null)), (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
        TestCase.assertEquals((long)1L, (long)this.sessionPool.openSessionCount());
        capturedProgress.last.setReplicated();
        capturedProgress.last.futureResult().complete(5);
        replicatingThread.join(15000L);
        TestCase.assertEquals((long)0L, (long)this.sessionPool.openSessionCount());
    }

    private Thread replicatingThread(RaftReplicator replicator, ReplicatedInteger content, boolean trackResult) {
        return new Thread(() -> {
            block4: {
                try {
                    Future futureResult = replicator.replicate((ReplicatedContent)content, trackResult);
                    if (!trackResult) break block4;
                    try {
                        futureResult.get();
                    }
                    catch (ExecutionException e) {
                        throw new IllegalStateException();
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException();
                }
            }
        });
    }

    private class CapturingOutbound<MESSAGE extends Message>
    implements Outbound<MemberId, MESSAGE> {
        private MemberId lastTo;
        private int count;

        private CapturingOutbound() {
        }

        public void send(MemberId to, MESSAGE message) {
            this.lastTo = to;
            ++this.count;
        }
    }

    private class CapturingProgressTracker
    implements ProgressTracker {
        private Progress last;

        private CapturingProgressTracker() {
        }

        public Progress start(DistributedOperation operation) {
            this.last = new Progress();
            return this.last;
        }

        public void trackReplication(DistributedOperation operation) {
            throw new UnsupportedOperationException();
        }

        public void trackResult(DistributedOperation operation, Result result) {
            throw new UnsupportedOperationException();
        }

        public void abort(DistributedOperation operation) {
            throw new UnsupportedOperationException();
        }

        public void triggerReplicationEvent() {
            throw new UnsupportedOperationException();
        }

        public int inProgressCount() {
            throw new UnsupportedOperationException();
        }
    }
}

