/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.vote;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.roles.Voting;
import org.neo4j.causalclustering.identity.MemberId;

@RunWith(value=MockitoJUnitRunner.class)
public class VotingTest {
    MemberId candidate = new MemberId(UUID.randomUUID());
    MemberId otherMember = new MemberId(UUID.randomUUID());
    long logTerm = 10L;
    long currentTerm = 20L;
    long appendIndex = 1000L;

    @Test
    public void shouldAcceptRequestWithIdenticalLog() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)this.appendIndex, null));
    }

    @Test
    public void shouldRejectRequestFromOldTerm() {
        Assert.assertFalse((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)(this.currentTerm - 1L), (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)this.appendIndex, null));
    }

    @Test
    public void shouldRejectRequestIfCandidateLogEndsAtLowerTerm() {
        Assert.assertFalse((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)(this.logTerm - 1L), (long)this.appendIndex, (long)this.appendIndex, null));
    }

    @Test
    public void shouldRejectRequestIfLogsEndInSameTermButCandidateLogIsShorter() {
        Assert.assertFalse((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)(this.appendIndex - 1L), null));
    }

    @Test
    public void shouldAcceptRequestIfLogsEndInSameTermAndCandidateLogIsSameLength() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)this.appendIndex, null));
    }

    @Test
    public void shouldAcceptRequestIfLogsEndInSameTermAndCandidateLogIsLonger() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)(this.appendIndex + 1L), null));
    }

    @Test
    public void shouldAcceptRequestIfLogsEndInHigherTermAndCandidateLogIsShorter() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)(this.logTerm + 1L), (long)this.appendIndex, (long)(this.appendIndex - 1L), null));
    }

    @Test
    public void shouldAcceptRequestIfLogEndsAtHigherTermAndCandidateLogIsSameLength() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)(this.logTerm + 1L), (long)this.appendIndex, (long)this.appendIndex, null));
    }

    @Test
    public void shouldAcceptRequestIfLogEndsAtHigherTermAndCandidateLogIsLonger() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)(this.logTerm + 1L), (long)this.appendIndex, (long)(this.appendIndex + 1L), null));
    }

    @Test
    public void shouldRejectRequestIfAlreadyVotedForOtherCandidate() {
        Assert.assertFalse((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)this.appendIndex, (MemberId)this.otherMember));
    }

    @Test
    public void shouldAcceptRequestIfAlreadyVotedForCandidate() {
        Assert.assertTrue((boolean)Voting.shouldVoteFor((MemberId)this.candidate, (long)this.currentTerm, (long)this.currentTerm, (long)this.logTerm, (long)this.logTerm, (long)this.appendIndex, (long)this.appendIndex, (MemberId)this.candidate));
    }
}

