/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.schedule;

import java.time.Clock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.schedule.DelayedRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.function.Predicates;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;
import org.neo4j.time.FakeClock;

public class DelayedRenewableTimeoutServiceTest {
    private final long TIMEOUT_MS = 100L;
    private final long LONG_TIME_MS = 30000L;
    private final long ERROR_MS = 1L;
    private final LifeSupport life = new LifeSupport();

    @Before
    public void startupLife() {
        this.life.init();
        this.life.start();
    }

    @After
    public void shutdownLife() {
        this.life.stop();
        this.life.shutdown();
    }

    @Test
    public void shouldTimeOutAfterTimeoutPeriod() throws Throwable {
        AtomicLong timeoutCount = new AtomicLong();
        DelayedRenewableTimeoutService timeoutService = new DelayedRenewableTimeoutService(Clocks.systemClock(), (LogProvider)NullLogProvider.getInstance());
        long startTime = System.currentTimeMillis();
        timeoutService.create((RenewableTimeoutService.TimeoutName)Timeouts.FOOBAR, 100L, 0L, timeout -> timeoutCount.incrementAndGet());
        this.life.add((Lifecycle)timeoutService);
        Predicates.await(timeoutCount::get, count -> count == 1L, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        long runTime = System.currentTimeMillis() - startTime;
        Assert.assertThat((Object)runTime, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(99L)));
    }

    @Test
    public void shouldNotTimeOutWhenRenewedWithinTimeoutPeriod() throws Throwable {
        AtomicLong timeoutCount = new AtomicLong();
        DelayedRenewableTimeoutService timeoutService = new DelayedRenewableTimeoutService(Clocks.systemClock(), (LogProvider)NullLogProvider.getInstance());
        long startTime = System.currentTimeMillis();
        RenewableTimeoutService.RenewableTimeout timeout = timeoutService.create((RenewableTimeoutService.TimeoutName)Timeouts.FOOBAR, 100L, 0L, timeout1 -> timeoutCount.incrementAndGet());
        this.life.add((Lifecycle)timeoutService);
        Thread.sleep(50L);
        long timeoutCountSample = timeoutCount.get();
        long sampleTime = System.currentTimeMillis();
        if (sampleTime < startTime + 100L) {
            Assert.assertThat((Object)timeoutCountSample, (Matcher)CoreMatchers.is((Object)0L));
        }
        long renewTime = System.currentTimeMillis();
        timeout.renew();
        if (System.currentTimeMillis() < startTime + 100L) {
            Predicates.await(timeoutCount::get, count -> count == 1L, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assert.assertThat((Object)System.currentTimeMillis(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(renewTime + 100L - 1L)));
        }
    }

    @Test
    public void shouldNotTimeOutWhenStopped() throws Throwable {
        AtomicLong timeoutCount = new AtomicLong();
        FakeClock clock = Clocks.fakeClock();
        DelayedRenewableTimeoutService timeoutService = new DelayedRenewableTimeoutService((Clock)clock, (LogProvider)NullLogProvider.getInstance());
        RenewableTimeoutService.RenewableTimeout timeout = timeoutService.create((RenewableTimeoutService.TimeoutName)Timeouts.FOOBAR, 100L, 0L, t -> timeoutCount.incrementAndGet());
        this.life.add((Lifecycle)timeoutService);
        clock.forward(100L, TimeUnit.MILLISECONDS);
        Predicates.await(timeoutCount::get, count -> count == 1L, (long)30000L, (TimeUnit)TimeUnit.MILLISECONDS, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        timeoutService.stop();
        timeoutService.shutdown();
        timeout.renew();
        Thread.sleep(50L);
        clock.forward(100L, TimeUnit.MILLISECONDS);
        Thread.sleep(50L);
        Assert.assertThat((Object)timeoutCount.get(), (Matcher)CoreMatchers.equalTo((Object)1L));
    }

    @Test
    public void shouldNotDeadLockWhenCancellingDuringExpiryHandling() throws Throwable {
        CountDownLatch latch = new CountDownLatch(1);
        FakeClock clock = Clocks.fakeClock();
        DelayedRenewableTimeoutService timeoutService = new DelayedRenewableTimeoutService((Clock)clock, (LogProvider)NullLogProvider.getInstance());
        final RenewableTimeoutService.RenewableTimeout timeout = timeoutService.create((RenewableTimeoutService.TimeoutName)Timeouts.FOOBAR, 100L, 0L, handler -> {
            try {
                latch.await(30000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.life.add((Lifecycle)timeoutService);
        clock.forward(100L, TimeUnit.MILLISECONDS);
        Thread.sleep(50L);
        Thread cancelThread = new Thread(){

            @Override
            public void run() {
                timeout.cancel();
            }
        };
        cancelThread.start();
        cancelThread.join(15000L);
        Assert.assertFalse((boolean)cancelThread.isAlive());
        latch.countDown();
        cancelThread.interrupt();
    }

    static enum Timeouts implements RenewableTimeoutService.TimeoutName
    {
        FOOBAR;

    }
}

