/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.PruneLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=Parameterized.class)
public class PruningTest {
    @Parameterized.Parameter
    public Role role;
    private MemberId myself = RaftTestMember.member(0);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({Role.FOLLOWER}, {Role.LEADER}, {Role.CANDIDATE});
    }

    @Test
    public void shouldGeneratePruneCommandsOnRequest() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).entryLog((RaftLog)raftLog).build();
        RaftMessages.PruneRequest pruneRequest = new RaftMessages.PruneRequest(1000L);
        Outcome outcome = this.role.handler.handle((RaftMessages.RaftMessage)pruneRequest, (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)Matchers.hasItem((Object)new PruneLogCommand(1000L)));
    }

    private Log log() {
        return NullLogProvider.getInstance().getLog(this.getClass());
    }
}

