/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.MessageUtils;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.outcome.AppendLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.BatchAppendLogEntries;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.ShipCommand;
import org.neo4j.causalclustering.core.consensus.roles.Leader;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerState;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class LeaderTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);
    private LogProvider logProvider = NullLogProvider.getInstance();
    private static final ReplicatedString CONTENT = ReplicatedString.valueOf("some-content-to-raft");

    @Test
    public void leaderShouldNotRespondToSuccessResponseFromFollowerThatWillSoonUpToDateViaInFlightMessages() throws Exception {
        Leader leader = new Leader();
        MemberId instance2 = RaftTestMember.member(2);
        FollowerState instance2State = LeaderTest.createArtificialFollowerState(84L);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        FollowerStates followerState = new FollowerStates();
        followerState = new FollowerStates(followerState, (Object)instance2, instance2State);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)100L);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)-1L);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.followerStates()).thenReturn((Object)followerState);
        Mockito.when((Object)state.term()).thenReturn((Object)4L);
        RaftMessages.AppendEntries.Response response = TestMessageBuilders.appendEntriesResponse().success().matchIndex(90L).term(4L).from(instance2).build();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)response, state, (Log)Mockito.mock(Log.class));
        Assert.assertTrue((boolean)outcome.getOutgoingMessages().isEmpty());
        FollowerStates leadersViewOfFollowerStates = outcome.getFollowerStates();
        Assert.assertEquals((long)90L, (long)leadersViewOfFollowerStates.get((Object)instance2).getMatchIndex());
    }

    @Test
    public void leaderShouldNotRespondToSuccessResponseThatIndicatesUpToDateFollower() throws Exception {
        Leader leader = new Leader();
        MemberId instance2 = RaftTestMember.member(2);
        FollowerState instance2State = LeaderTest.createArtificialFollowerState(84L);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        FollowerStates followerState = new FollowerStates();
        followerState = new FollowerStates(followerState, (Object)instance2, instance2State);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)100L);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)-1L);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.followerStates()).thenReturn((Object)followerState);
        Mockito.when((Object)state.term()).thenReturn((Object)4L);
        RaftMessages.AppendEntries.Response response = TestMessageBuilders.appendEntriesResponse().success().matchIndex(100L).term(4L).from(instance2).build();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)response, state, (Log)Mockito.mock(Log.class));
        Assert.assertTrue((boolean)outcome.getOutgoingMessages().isEmpty());
        FollowerStates updatedFollowerStates = outcome.getFollowerStates();
        Assert.assertEquals((long)100L, (long)updatedFollowerStates.get((Object)instance2).getMatchIndex());
    }

    @Test
    public void leaderShouldRespondToSuccessResponseThatIndicatesLaggingFollowerWithJustWhatItsMissing() throws Exception {
        Leader leader = new Leader();
        MemberId instance2 = RaftTestMember.member(2);
        FollowerState instance2State = LeaderTest.createArtificialFollowerState(50L);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        FollowerStates followerState = new FollowerStates();
        followerState = new FollowerStates(followerState, (Object)instance2, instance2State);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)100L);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)-1L);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.followerStates()).thenReturn((Object)followerState);
        Mockito.when((Object)state.term()).thenReturn((Object)231L);
        RaftMessages.AppendEntries.Response response = TestMessageBuilders.appendEntriesResponse().success().matchIndex(89L).term(231L).from(instance2).build();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)response, state, (Log)Mockito.mock(Log.class));
        int matchCount = 0;
        for (ShipCommand shipCommand : outcome.getShipCommands()) {
            if (!(shipCommand instanceof ShipCommand.Match)) continue;
            ++matchCount;
        }
        Assert.assertThat((Object)matchCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void leaderShouldIgnoreSuccessResponseThatIndicatesLaggingWhileLocalStateIndicatesFollowerIsCaughtUp() throws Exception {
        Leader leader = new Leader();
        MemberId instance2 = RaftTestMember.member(2);
        int j = 100;
        FollowerState instance2State = LeaderTest.createArtificialFollowerState(j);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        FollowerStates followerState = new FollowerStates();
        followerState = new FollowerStates(followerState, (Object)instance2, instance2State);
        ReadableRaftLog logMock = (ReadableRaftLog)Mockito.mock(ReadableRaftLog.class);
        Mockito.when((Object)logMock.appendIndex()).thenReturn((Object)100L);
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)-1L);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)logMock);
        Mockito.when((Object)state.followerStates()).thenReturn((Object)followerState);
        Mockito.when((Object)state.term()).thenReturn((Object)4L);
        RaftMessages.AppendEntries.Response response = TestMessageBuilders.appendEntriesResponse().success().matchIndex(80L).term(4L).from(instance2).build();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)response, state, (Log)Mockito.mock(Log.class));
        Assert.assertTrue((boolean)outcome.getOutgoingMessages().isEmpty());
        FollowerStates updatedFollowerStates = outcome.getFollowerStates();
        Assert.assertEquals((long)100L, (long)updatedFollowerStates.get((Object)instance2).getMatchIndex());
    }

    private static FollowerState createArtificialFollowerState(long matchIndex) {
        return new FollowerState().onSuccessResponse(matchIndex);
    }

    @Test
    public void leaderShouldSpawnMismatchCommandOnFailure() throws Exception {
        Leader leader = new Leader();
        MemberId instance2 = RaftTestMember.member(2);
        FollowerState instance2State = LeaderTest.createArtificialFollowerState(100L);
        ReadableRaftState state = (ReadableRaftState)Mockito.mock(ReadableRaftState.class);
        FollowerStates followerState = new FollowerStates();
        followerState = new FollowerStates(followerState, (Object)instance2, instance2State);
        InMemoryRaftLog log = new InMemoryRaftLog();
        for (int i = 0; i <= 100; ++i) {
            log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(i))});
        }
        Mockito.when((Object)state.commitIndex()).thenReturn((Object)-1L);
        Mockito.when((Object)state.entryLog()).thenReturn((Object)log);
        Mockito.when((Object)state.followerStates()).thenReturn((Object)followerState);
        Mockito.when((Object)state.term()).thenReturn((Object)4L);
        RaftMessages.AppendEntries.Response response = TestMessageBuilders.appendEntriesResponse().failure().appendIndex(0L).matchIndex(-1L).term(4L).from(instance2).build();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)response, state, (Log)Mockito.mock(Log.class));
        int mismatchCount = 0;
        for (ShipCommand shipCommand : outcome.getShipCommands()) {
            if (!(shipCommand instanceof ShipCommand.Mismatch)) continue;
            ++mismatchCount;
        }
        Assert.assertThat((Object)mismatchCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void leaderShouldRejectAppendEntriesResponseWithNewerTermAndBecomeAFollower() throws Exception {
        RaftState state = RaftStateBuilder.raftState().myself(this.myself).build();
        Leader leader = new Leader();
        RaftMessages.AppendEntries.Response message = TestMessageBuilders.appendEntriesResponse().from(this.member1).term(state.term() + 1L).build();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)message, (ReadableRaftState)state, this.log());
        Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)outcome.getOutgoingMessages()));
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
        Assert.assertEquals((long)0L, (long)Iterables.count((Iterable)outcome.getLogCommands()));
        Assert.assertEquals((long)(state.term() + 1L), (long)outcome.getTerm());
    }

    @Test
    public void leaderShouldSendHeartbeatsToAllClusterMembersOnReceiptOfHeartbeatTick() throws Exception {
        RaftState state = RaftStateBuilder.raftState().votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Leader leader = new Leader();
        leader.handle((RaftMessages.RaftMessage)new RaftMessages.HeartbeatResponse(this.member1), (ReadableRaftState)state, this.log());
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Heartbeat(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertTrue((boolean)(MessageUtils.messageFor(outcome, this.member1) instanceof RaftMessages.Heartbeat));
        Assert.assertTrue((boolean)(MessageUtils.messageFor(outcome, this.member2) instanceof RaftMessages.Heartbeat));
    }

    @Test
    public void leaderShouldStepDownWhenLackingHeartbeatResponses() throws Exception {
        RaftState state = RaftStateBuilder.raftState().votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Leader leader = new Leader();
        leader.handle((RaftMessages.RaftMessage)new RaftMessages.HeartbeatResponse(this.myself), (ReadableRaftState)state, this.log());
        leader.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getRole(), (Matcher)Matchers.not((Object)Role.LEADER));
    }

    @Test
    public void leaderShouldNotStepDownWhenReceivedQuorumOfHeartbeatResponses() throws Exception {
        RaftState state = RaftStateBuilder.raftState().votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Leader leader = new Leader();
        leader.handle((RaftMessages.RaftMessage)new RaftMessages.HeartbeatResponse(this.member1), (ReadableRaftState)state, this.log());
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)new RaftMessages.Timeout.Election(this.myself), (ReadableRaftState)state, this.log());
        Assert.assertThat((Object)outcome.getRole(), (Matcher)Matchers.is((Object)Role.LEADER));
    }

    @Test
    public void leaderShouldDecideToAppendToItsLogAndSendAppendEntriesMessageOnReceiptOfClientProposal() throws Exception {
        RaftState state = RaftStateBuilder.raftState().votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Leader leader = new Leader();
        RaftMessages.NewEntry.Request newEntryRequest = new RaftMessages.NewEntry.Request(RaftTestMember.member(9), (ReplicatedContent)CONTENT);
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)newEntryRequest, (ReadableRaftState)state, this.log());
        AppendLogEntry logCommand = (AppendLogEntry)Iterables.single((Iterable)outcome.getLogCommands());
        Assert.assertEquals((long)0L, (long)logCommand.index);
        Assert.assertEquals((long)0L, (long)logCommand.entry.term());
        ShipCommand.NewEntries shipCommand = (ShipCommand.NewEntries)Iterables.single((Iterable)outcome.getShipCommands());
        Assert.assertEquals((Object)shipCommand, (Object)new ShipCommand.NewEntries(-1L, -1L, new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)CONTENT)}));
    }

    @Test
    public void leaderShouldHandleBatch() throws Exception {
        RaftState state = RaftStateBuilder.raftState().votingMembers(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})).build();
        Leader leader = new Leader();
        int BATCH_SIZE = 3;
        RaftMessages.NewEntry.BatchRequest batchRequest = new RaftMessages.NewEntry.BatchRequest(BATCH_SIZE);
        batchRequest.add((ReplicatedContent)ReplicatedInteger.valueOf(0));
        batchRequest.add((ReplicatedContent)ReplicatedInteger.valueOf(1));
        batchRequest.add((ReplicatedContent)ReplicatedInteger.valueOf(2));
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)batchRequest, (ReadableRaftState)state, this.log());
        BatchAppendLogEntries logCommand = (BatchAppendLogEntries)Iterables.single((Iterable)outcome.getLogCommands());
        Assert.assertEquals((long)0L, (long)logCommand.baseIndex);
        for (int i = 0; i < BATCH_SIZE; ++i) {
            Assert.assertEquals((long)0L, (long)logCommand.entries[i].term());
            Assert.assertEquals((long)i, (long)((ReplicatedInteger)logCommand.entries[i].content()).get());
        }
        ShipCommand.NewEntries shipCommand = (ShipCommand.NewEntries)Iterables.single((Iterable)outcome.getShipCommands());
        Assert.assertEquals((Object)shipCommand, (Object)new ShipCommand.NewEntries(-1L, -1L, new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0)), new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(1)), new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(2))}));
    }

    @Test
    public void leaderShouldCommitOnMajorityResponse() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new ReplicatedString("lalalala"))});
        RaftState state = RaftStateBuilder.raftState().votingMembers(this.member1, this.member2).term(0L).lastLogIndexBeforeWeBecameLeader(-1L).leader(this.myself).leaderCommit(-1L).entryLog((RaftLog)raftLog).messagesSentToFollower(this.member1, raftLog.appendIndex() + 1L).messagesSentToFollower(this.member2, raftLog.appendIndex() + 1L).build();
        Leader leader = new Leader();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Response(this.member1, 0L, true, 0L, 0L), (ReadableRaftState)state, this.log());
        Assert.assertEquals((long)0L, (long)outcome.getCommitIndex());
        Assert.assertEquals((long)0L, (long)outcome.getLeaderCommit());
    }

    @Test
    public void leaderShouldCommitAllPreviouslyAppendedEntriesWhenCommittingLaterEntryInSameTerm() throws Exception {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new ReplicatedString("first!"))});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new ReplicatedString("second"))});
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new ReplicatedString("third"))});
        RaftState state = RaftStateBuilder.raftState().votingMembers(this.myself, this.member1, this.member2).term(0L).entryLog((RaftLog)raftLog).messagesSentToFollower(this.member1, raftLog.appendIndex() + 1L).messagesSentToFollower(this.member2, raftLog.appendIndex() + 1L).build();
        Leader leader = new Leader();
        Outcome outcome = leader.handle((RaftMessages.RaftMessage)new RaftMessages.AppendEntries.Response(this.member1, 0L, true, 2L, 2L), (ReadableRaftState)state, this.log());
        state.update(outcome);
        Assert.assertEquals((long)2L, (long)state.commitIndex());
    }

    private Log log() {
        return this.logProvider.getLog(this.getClass());
    }
}

