/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMachineBuilder;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.schedule.ControlledRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;
import org.neo4j.helpers.collection.Iterators;

@RunWith(value=MockitoJUnitRunner.class)
public class ElectionTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);
    @Mock
    private Inbound inbound;
    @Mock
    private Outbound<MemberId, RaftMessages.RaftMessage> outbound;

    @Test
    public void candidateShouldWinElectionAndBecomeLeader() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).outbound(this.outbound).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member2).term(1L).grant().build());
        Assert.assertEquals((long)1L, (long)raft.term());
        Assert.assertEquals((Object)Role.LEADER, (Object)raft.currentRole());
        ((Outbound)Mockito.verify(this.outbound)).send(Matchers.eq((Object)this.member1), (Message)Matchers.isA(RaftMessages.AppendEntries.Request.class));
        ((Outbound)Mockito.verify(this.outbound)).send(Matchers.eq((Object)this.member2), (Message)Matchers.isA(RaftMessages.AppendEntries.Request.class));
    }

    @Test
    public void candidateShouldLoseElectionAndRemainCandidate() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).outbound(this.outbound).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).deny().build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member2).term(1L).deny().build());
        Assert.assertEquals((long)1L, (long)raft.term());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)raft.currentRole());
        ((Outbound)Mockito.verify(this.outbound, (VerificationMode)Mockito.never())).send(Matchers.eq((Object)this.member1), (Message)Matchers.isA(RaftMessages.AppendEntries.Request.class));
        ((Outbound)Mockito.verify(this.outbound, (VerificationMode)Mockito.never())).send(Matchers.eq((Object)this.member2), (Message)Matchers.isA(RaftMessages.AppendEntries.Request.class));
    }

    @Test
    public void candidateShouldVoteForTheSameCandidateInTheSameTerm() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).outbound(this.outbound).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteRequest().from(this.member1).candidate(this.member1).term(1L).build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteRequest().from(this.member1).candidate(this.member1).term(1L).build());
        ((Outbound)Mockito.verify(this.outbound, (VerificationMode)Mockito.times((int)2))).send((Object)this.member1, (Message)TestMessageBuilders.voteResponse().term(1L).grant().build());
    }
}

