/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.AppendLogEntry;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.state.RaftState;
import org.neo4j.causalclustering.core.consensus.state.RaftStateBuilder;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

@RunWith(value=MockitoJUnitRunner.class)
public class CandidateTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    @Mock
    private Inbound inbound;
    private LogProvider logProvider = NullLogProvider.getInstance();

    @Test
    public void shouldBeElectedLeaderOnReceivingGrantedVoteResponseWithCurrentTerm() throws Exception {
        RaftState state = this.newState();
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(state.term()).from(this.member1).grant().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.LEADER, (Object)outcome.getRole());
        Assert.assertThat((Object)outcome.getLogCommands(), (Matcher)CoreMatchers.hasItem((Object)new AppendLogEntry(0L, new RaftLogEntry(state.term(), (ReplicatedContent)new NewLeaderBarrier()))));
    }

    @Test
    public void shouldStayAsCandidateOnReceivingDeniedVoteResponseWithCurrentTerm() throws Exception {
        RaftState state = this.newState();
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(state.term()).from(this.member1).deny().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    @Test
    public void shouldUpdateTermOnReceivingVoteResponseWithLaterTerm() throws Exception {
        RaftState state = this.newState();
        long voterTerm = state.term() + 1L;
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(voterTerm).from(this.member1).grant().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)outcome.getRole());
        Assert.assertEquals((long)voterTerm, (long)outcome.getTerm());
    }

    @Test
    public void shouldRejectVoteResponseWithOldTerm() throws Exception {
        RaftState state = this.newState();
        long voterTerm = state.term() - 1L;
        Outcome outcome = Role.CANDIDATE.handler.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().term(voterTerm).from(this.member1).grant().build(), (ReadableRaftState)state, this.log());
        Assert.assertEquals((Object)Role.CANDIDATE, (Object)outcome.getRole());
    }

    public RaftState newState() throws IOException {
        return RaftStateBuilder.raftState().myself(this.myself).build();
    }

    private Log log() {
        return this.logProvider.getLog(this.getClass());
    }
}

