/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMachineBuilder;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.membership.RaftTestGroup;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;

@RunWith(value=MockitoJUnitRunner.class)
public class AppendEntriesMessageFlowTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId otherMember = RaftTestMember.member(1);
    private ReplicatedInteger data = ReplicatedInteger.valueOf(1);
    @Mock
    private Outbound<MemberId, RaftMessages.RaftMessage> outbound;
    private RaftMachine raft;

    ReplicatedInteger data(int value) {
        return ReplicatedInteger.valueOf(value);
    }

    @Before
    public void setup() throws IOException {
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new RaftTestGroup(0))});
        this.raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).raftLog((RaftLog)raftLog).outbound(this.outbound).build();
    }

    @Test
    public void shouldReturnFalseOnAppendRequestFromOlderTerm() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(-1L).prevLogIndex(0L).prevLogTerm(0L).leaderCommit(0L).build());
        ((Outbound)Mockito.verify(this.outbound)).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).appendIndex(0L).matchIndex(-1L).failure().build()));
    }

    @Test
    public void shouldReturnTrueOnAppendRequestWithFirstLogEntry() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(1L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)this.data)).leaderCommit(-1L).build());
        ((Outbound)Mockito.verify(this.outbound)).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().appendIndex(1L).matchIndex(1L).from(this.myself).term(1L).success().build()));
    }

    @Test
    public void shouldReturnFalseOnAppendRequestWhenPrevLogEntryNotMatched() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(0L).prevLogTerm(1L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data)).build());
        ((Outbound)Mockito.verify(this.outbound)).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().matchIndex(-1L).appendIndex(0L).from(this.myself).term(0L).failure().build()));
    }

    @Test
    public void shouldAcceptSequenceOfAppendEntries() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data(1))).leaderCommit(-1L).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(1L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data(2))).leaderCommit(-1L).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(2L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data(3))).leaderCommit(0L).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(1L).prevLogIndex(3L).prevLogTerm(0L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)this.data(4))).leaderCommit(1L).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(1L).prevLogIndex(4L).prevLogTerm(1L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)this.data(5))).leaderCommit(2L).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(1L).prevLogIndex(5L).prevLogTerm(1L).logEntry(new RaftLogEntry(1L, (ReplicatedContent)this.data(6))).leaderCommit(4L).build());
        InOrder invocationOrder = Mockito.inOrder((Object[])new Object[]{this.outbound});
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).appendIndex(1L).matchIndex(1L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).appendIndex(2L).matchIndex(2L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).appendIndex(3L).matchIndex(3L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(1L).appendIndex(4L).matchIndex(4L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(1L).appendIndex(5L).matchIndex(5L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(1L).appendIndex(6L).matchIndex(6L).success().build()));
    }

    @Test
    public void shouldReturnFalseIfLogHistoryDoesNotMatch() throws Exception {
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(0L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data(1))).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(1L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data(2))).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(0L).prevLogIndex(2L).prevLogTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data(3))).build());
        this.raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.otherMember).leaderTerm(2L).prevLogIndex(3L).prevLogTerm(1L).logEntry(new RaftLogEntry(2L, (ReplicatedContent)this.data(4))).build());
        InOrder invocationOrder = Mockito.inOrder((Object[])new Object[]{this.outbound});
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).matchIndex(1L).appendIndex(1L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).matchIndex(2L).appendIndex(2L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(0L).matchIndex(3L).appendIndex(3L).success().build()));
        ((Outbound)invocationOrder.verify(this.outbound, Mockito.times((int)1))).send(Matchers.same((Object)this.otherMember), (Message)Matchers.eq((Object)TestMessageBuilders.appendEntriesResponse().from(this.myself).term(2L).matchIndex(-1L).appendIndex(3L).failure().build()));
    }
}

