/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.outcome;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.consensus.outcome.TruncateLogCommand;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class TruncateLogCommandTest {
    @Test
    public void applyTo() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(this.getClass());
        long fromIndex = 2L;
        TruncateLogCommand truncateLogCommand = new TruncateLogCommand(fromIndex);
        InFlightMap inFlightMap = new InFlightMap();
        inFlightMap.put(Long.valueOf(0L), (Object)new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0)));
        inFlightMap.put(Long.valueOf(1L), (Object)new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1)));
        inFlightMap.put(Long.valueOf(2L), (Object)new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2)));
        inFlightMap.put(Long.valueOf(3L), (Object)new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(3)));
        truncateLogCommand.applyTo(inFlightMap, log);
        Assert.assertNotNull((Object)inFlightMap.get(Long.valueOf(0L)));
        Assert.assertNotNull((Object)inFlightMap.get(Long.valueOf(1L)));
        Assert.assertNull((Object)inFlightMap.get(Long.valueOf(2L)));
        Assert.assertNull((Object)inFlightMap.get(Long.valueOf(3L)));
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).debug("Start truncating in-flight-map from index %d. Current map:%n%s", new Object[]{fromIndex, inFlightMap})});
    }

    @Test
    public void shouldTruncateWithGaps() throws Exception {
        long fromIndex = 1L;
        TruncateLogCommand truncateLogCommand = new TruncateLogCommand(fromIndex);
        InFlightMap inFlightMap = new InFlightMap();
        inFlightMap.put(Long.valueOf(0L), (Object)new RaftLogEntry(0L, (ReplicatedContent)ReplicatedInteger.valueOf(0)));
        inFlightMap.put(Long.valueOf(2L), (Object)new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1)));
        inFlightMap.put(Long.valueOf(4L), (Object)new RaftLogEntry(2L, (ReplicatedContent)ReplicatedInteger.valueOf(2)));
        truncateLogCommand.applyTo(inFlightMap, (Log)NullLog.getInstance());
        inFlightMap.put(Long.valueOf(1L), (Object)new RaftLogEntry(3L, (ReplicatedContent)ReplicatedInteger.valueOf(1)));
        inFlightMap.put(Long.valueOf(2L), (Object)new RaftLogEntry(4L, (ReplicatedContent)ReplicatedInteger.valueOf(2)));
        Assert.assertNotNull((Object)inFlightMap.get(Long.valueOf(0L)));
        Assert.assertNotNull((Object)inFlightMap.get(Long.valueOf(1L)));
        Assert.assertNotNull((Object)inFlightMap.get(Long.valueOf(2L)));
    }
}

