/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.neo4j.causalclustering.core.consensus.DirectNetworking;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftTestFixture;
import org.neo4j.causalclustering.core.consensus.membership.RaftTestGroup;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;

@RunWith(value=MockitoJUnitRunner.class)
public class RaftGroupMembershipTest {
    @Mock
    private Outbound<MemberId, Message> outbound;
    @Mock
    private Inbound inbound;

    @Test
    public void shouldNotFormGroupWithoutAnyBootstrapping() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId[] ids = new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, ids);
        fixture.members().setTargetMembershipSet(new RaftTestGroup(ids).getMembers());
        fixture.members().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        Assert.assertThat((Object)fixture.members(), this.hasCurrentMembers(new RaftTestGroup(new int[0])));
        Assert.assertEquals((long)0L, (long)fixture.members().withRole(Role.LEADER).size());
        Assert.assertEquals((long)3L, (long)fixture.members().withRole(Role.FOLLOWER).size());
    }

    @Test
    public void shouldAddSingleInstanceToExistingRaftGroup() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId stable1 = RaftTestMember.member(1);
        MemberId stable2 = RaftTestMember.member(2);
        MemberId toBeAdded = RaftTestMember.member(3);
        MemberId[] initialMembers = new MemberId[]{leader, stable1, stable2};
        MemberId[] finalMembers = new MemberId[]{leader, stable1, stable2, toBeAdded};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, finalMembers);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader).raftInstance().setTargetMembershipSet(new RaftTestGroup(finalMembers).getMembers());
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        Assert.assertThat((Object)fixture.members().withIds(finalMembers), this.hasCurrentMembers(new RaftTestGroup(finalMembers)));
        Assert.assertEquals((long)1L, (long)fixture.members().withRole(Role.LEADER).size());
        Assert.assertEquals((long)3L, (long)fixture.members().withRole(Role.FOLLOWER).size());
    }

    @Test
    public void shouldAddMultipleInstancesToExistingRaftGroup() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId stable1 = RaftTestMember.member(1);
        MemberId stable2 = RaftTestMember.member(2);
        MemberId toBeAdded1 = RaftTestMember.member(3);
        MemberId toBeAdded2 = RaftTestMember.member(4);
        MemberId toBeAdded3 = RaftTestMember.member(5);
        MemberId[] initialMembers = new MemberId[]{leader, stable1, stable2};
        MemberId[] finalMembers = new MemberId[]{leader, stable1, stable2, toBeAdded1, toBeAdded2, toBeAdded3};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, finalMembers);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().setTargetMembershipSet(new RaftTestGroup(finalMembers).getMembers());
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        Assert.assertThat((Object)fixture.members().withIds(finalMembers), this.hasCurrentMembers(new RaftTestGroup(finalMembers)));
        Assert.assertEquals((long)1L, (long)fixture.members().withRole(Role.LEADER).size());
        Assert.assertEquals((long)5L, (long)fixture.members().withRole(Role.FOLLOWER).size());
    }

    @Test
    public void shouldRemoveSingleInstanceFromExistingRaftGroup() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId stable = RaftTestMember.member(1);
        MemberId toBeRemoved = RaftTestMember.member(2);
        MemberId[] initialMembers = new MemberId[]{leader, stable, toBeRemoved};
        MemberId[] finalMembers = new MemberId[]{leader, stable};
        RaftTestFixture fixture = new RaftTestFixture(net, 2, initialMembers);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        fixture.members().setTargetMembershipSet(new RaftTestGroup(finalMembers).getMembers());
        net.processMessages();
        Assert.assertThat((Object)fixture.members().withIds(finalMembers), this.hasCurrentMembers(new RaftTestGroup(finalMembers)));
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(finalMembers).withRole(Role.LEADER).size());
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(finalMembers).withRole(Role.FOLLOWER).size());
    }

    @Test
    public void shouldRemoveMultipleInstancesFromExistingRaftGroup() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId stable = RaftTestMember.member(1);
        MemberId toBeRemoved1 = RaftTestMember.member(2);
        MemberId toBeRemoved2 = RaftTestMember.member(3);
        MemberId toBeRemoved3 = RaftTestMember.member(4);
        MemberId[] initialMembers = new MemberId[]{leader, stable, toBeRemoved1, toBeRemoved2, toBeRemoved3};
        MemberId[] finalMembers = new MemberId[]{leader, stable};
        RaftTestFixture fixture = new RaftTestFixture(net, 2, initialMembers);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader).raftInstance().setTargetMembershipSet(new RaftTestGroup(finalMembers).getMembers());
        net.processMessages();
        Assert.assertThat((Object)fixture.members().withIds(finalMembers), this.hasCurrentMembers(new RaftTestGroup(finalMembers)));
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(finalMembers).withRole(Role.LEADER).size());
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(finalMembers).withRole(Role.FOLLOWER).size());
    }

    @Test
    public void shouldHandleMixedChangeToExistingRaftGroup() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId stable = RaftTestMember.member(1);
        MemberId toBeRemoved1 = RaftTestMember.member(2);
        MemberId toBeRemoved2 = RaftTestMember.member(3);
        MemberId toBeAdded1 = RaftTestMember.member(4);
        MemberId toBeAdded2 = RaftTestMember.member(5);
        MemberId[] everyone = new MemberId[]{leader, stable, toBeRemoved1, toBeRemoved2, toBeAdded1, toBeAdded2};
        MemberId[] initialMembers = new MemberId[]{leader, stable, toBeRemoved1, toBeRemoved2};
        MemberId[] finalMembers = new MemberId[]{leader, stable, toBeAdded1, toBeAdded2};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, everyone);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader).raftInstance().setTargetMembershipSet(new RaftTestGroup(finalMembers).getMembers());
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        Assert.assertThat((Object)fixture.members().withIds(finalMembers), this.hasCurrentMembers(new RaftTestGroup(finalMembers)));
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(finalMembers).withRole(Role.LEADER).size());
        Assert.assertEquals((long)3L, (long)fixture.members().withIds(finalMembers).withRole(Role.FOLLOWER).size());
    }

    @Test
    public void shouldRemoveLeaderFromExistingRaftGroupAndActivelyTransferLeadership() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId stable1 = RaftTestMember.member(1);
        MemberId stable2 = RaftTestMember.member(2);
        MemberId[] initialMembers = new MemberId[]{leader, stable1, stable2};
        MemberId[] finalMembers = new MemberId[]{stable1, stable2};
        RaftTestFixture fixture = new RaftTestFixture(net, 2, initialMembers);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader).raftInstance().setTargetMembershipSet(new RaftTestGroup(finalMembers).getMembers());
        net.processMessages();
        fixture.members().withId(stable1).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        Assert.assertThat((Object)fixture.members().withIds(finalMembers), this.hasCurrentMembers(new RaftTestGroup(finalMembers)));
        Assert.assertTrue((fixture.members().withId(stable1).raftInstance().isLeader() || fixture.members().withId(stable2).raftInstance().isLeader() ? 1 : 0) != 0);
    }

    @Test
    public void shouldRemoveLeaderAndAddItBackIn() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader1 = RaftTestMember.member(0);
        MemberId leader2 = RaftTestMember.member(1);
        MemberId stable1 = RaftTestMember.member(2);
        MemberId stable2 = RaftTestMember.member(3);
        MemberId[] allMembers = new MemberId[]{leader1, leader2, stable1, stable2};
        MemberId[] fewerMembers = new MemberId[]{leader2, stable1, stable2};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, allMembers);
        fixture.bootstrap(allMembers);
        fixture.members().withId(leader1).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader1).raftInstance().setTargetMembershipSet(new RaftTestGroup(fewerMembers).getMembers());
        net.processMessages();
        fixture.members().withId(leader2).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader2).raftInstance().setTargetMembershipSet(new RaftTestGroup(allMembers).getMembers());
        net.processMessages();
        fixture.members().withId(leader2).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        Assert.assertTrue((boolean)fixture.members().withId(leader2).raftInstance().isLeader());
        Assert.assertThat((Object)fixture.members().withIds(allMembers), this.hasCurrentMembers(new RaftTestGroup(allMembers)));
    }

    @Test
    public void shouldRemoveFollowerAndAddItBackIn() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId unstable = RaftTestMember.member(1);
        MemberId stable1 = RaftTestMember.member(2);
        MemberId stable2 = RaftTestMember.member(3);
        MemberId[] allMembers = new MemberId[]{leader, unstable, stable1, stable2};
        MemberId[] fewerMembers = new MemberId[]{leader, stable1, stable2};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, allMembers);
        fixture.bootstrap(allMembers);
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader).raftInstance().setTargetMembershipSet(new RaftTestGroup(fewerMembers).getMembers());
        net.processMessages();
        Assert.assertTrue((boolean)fixture.members().withId(leader).raftInstance().isLeader());
        Assert.assertThat((Object)fixture.members().withIds(fewerMembers), this.hasCurrentMembers(new RaftTestGroup(fewerMembers)));
        fixture.members().withId(leader).raftInstance().setTargetMembershipSet(new RaftTestGroup(allMembers).getMembers());
        net.processMessages();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        net.processMessages();
        Assert.assertTrue((boolean)fixture.members().withId(leader).raftInstance().isLeader());
        Assert.assertThat((Object)fixture.members().withIds(allMembers), this.hasCurrentMembers(new RaftTestGroup(allMembers)));
    }

    @Test
    public void shouldElectNewLeaderWhenOldOneAbruptlyLeaves() throws Exception {
        DirectNetworking net = new DirectNetworking();
        MemberId leader1 = RaftTestMember.member(0);
        MemberId leader2 = RaftTestMember.member(1);
        MemberId stable = RaftTestMember.member(2);
        MemberId[] initialMembers = new MemberId[]{leader1, leader2, stable};
        RaftTestFixture fixture = new RaftTestFixture(net, 2, initialMembers);
        fixture.bootstrap(initialMembers);
        fixture.members().withId(leader1).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        net.disconnect(leader1);
        fixture.members().withId(leader2).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        Assert.assertTrue((boolean)fixture.members().withId(leader2).raftInstance().isLeader());
        Assert.assertFalse((boolean)fixture.members().withId(stable).raftInstance().isLeader());
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(leader2, stable).withRole(Role.LEADER).size());
        Assert.assertEquals((long)1L, (long)fixture.members().withIds(leader2, stable).withRole(Role.FOLLOWER).size());
    }

    private Matcher<? super RaftTestFixture.Members> hasCurrentMembers(final RaftTestGroup raftGroup) {
        return new TypeSafeMatcher<RaftTestFixture.Members>(){

            protected boolean matchesSafely(RaftTestFixture.Members members) {
                for (RaftTestFixture.MemberFixture finalMember : members) {
                    if (raftGroup.equals(new RaftTestGroup(finalMember.raftInstance().replicationMembers()))) continue;
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("Raft group: ").appendValue((Object)raftGroup);
            }
        };
    }
}

