/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.lang.reflect.Field;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.segmented.Terms;

public class TermsTest {
    private Terms terms;

    @Test
    public void shouldHaveCorrectInitialValues() throws Exception {
        long prevIndex = 5L;
        long prevTerm = 10L;
        this.terms = new Terms(prevIndex, prevTerm);
        this.assertTermInRange(-1L, prevIndex, index -> -1L);
        Assert.assertEquals((long)prevTerm, (long)this.terms.get(prevIndex));
        this.assertTermInRange(prevIndex + 1L, prevIndex + 10L, index -> -1L);
    }

    @Test
    public void shouldReturnAppendedTerms() throws Exception {
        this.terms = new Terms(-1L, -1L);
        int count = 10;
        this.appendRange(0L, (long)count, index -> index * 2L);
        this.assertTermInRange(0L, (long)count, index -> index * 2L);
        Assert.assertEquals((long)-1L, (long)this.terms.get(-1L));
        Assert.assertEquals((long)-1L, (long)this.terms.get((long)count));
    }

    @Test
    public void shouldReturnAppendedTermsLongerRanges() throws Exception {
        long term;
        this.terms = new Terms(-1L, -1L);
        int count = 10;
        for (term = 0L; term < (long)count; ++term) {
            this.appendRange(term * (long)count, (term + 1L) * (long)count, term);
        }
        for (term = 0L; term < (long)count; ++term) {
            this.assertTermInRange(term * (long)count, (term + 1L) * (long)count, term);
        }
    }

    @Test
    public void shouldOnlyAcceptInOrderIndexes() throws Exception {
        long prevIndex = 3L;
        long term = 3L;
        this.terms = new Terms(prevIndex, term);
        try {
            this.terms.append(prevIndex, term);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.terms.append(prevIndex + 1L, term);
        this.terms.append(prevIndex + 2L, term);
        this.terms.append(prevIndex + 3L, term);
        try {
            this.terms.append(prevIndex + 5L, term);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.terms.append(prevIndex + 4L, term);
        this.terms.append(prevIndex + 5L, term);
        this.terms.append(prevIndex + 6L, term);
    }

    @Test
    public void shouldOnlyAcceptMonotonicTerms() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.terms.append(prevIndex + 1L, term);
        this.terms.append(prevIndex + 2L, term);
        this.terms.append(prevIndex + 3L, term + 1L);
        this.terms.append(prevIndex + 4L, term + 1L);
        this.terms.append(prevIndex + 5L, term + 2L);
        this.terms.append(prevIndex + 6L, term + 2L);
        try {
            this.terms.append(prevIndex + 7L, term + 1L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotTruncateNegativeIndexes() throws Exception {
        this.terms = new Terms(-1L, -1L);
        this.terms.append(0L, 0L);
        try {
            this.terms.truncate(-1L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotTruncateLessThanLowestIndex() throws Exception {
        this.terms = new Terms(5L, 1L);
        try {
            this.terms.truncate(4L);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldTruncateInCurrentRange() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, 20L, term);
        Assert.assertEquals((long)term, (long)this.terms.get(19L));
        long truncateFromIndex = 15L;
        this.terms.truncate(truncateFromIndex);
        this.assertTermInRange(prevIndex + 1L, truncateFromIndex, index -> term);
        this.assertTermInRange(truncateFromIndex, 30L, index -> -1L);
    }

    @Test
    public void shouldTruncateAtExactBoundary() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        long truncateFromIndex = prevIndex + 10L;
        this.terms.truncate(truncateFromIndex);
        this.assertTermInRange(prevIndex + 1L, prevIndex + 10L, term);
        this.assertTermInRange(prevIndex + 10L, truncateFromIndex, -1L);
    }

    @Test
    public void shouldTruncateCompleteCurrentRange() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        this.appendRange(prevIndex + 20L, prevIndex + 30L, term + 2L);
        long truncateFromIndex = prevIndex + 15L;
        this.terms.truncate(truncateFromIndex);
        this.assertTermInRange(prevIndex + 1L, prevIndex + 10L, term);
        this.assertTermInRange(prevIndex + 10L, truncateFromIndex, term + 1L);
        this.assertTermInRange(truncateFromIndex, prevIndex + 30L, -1L);
    }

    @Test
    public void shouldTruncateSeveralCompleteRanges() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        this.appendRange(prevIndex + 20L, prevIndex + 30L, term + 2L);
        long truncateFromIndex = prevIndex + 5L;
        this.terms.truncate(truncateFromIndex);
        this.assertTermInRange(prevIndex + 1L, truncateFromIndex, term);
        this.assertTermInRange(truncateFromIndex, prevIndex + 30L, -1L);
    }

    @Test
    public void shouldAppendAfterTruncate() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 10L);
        long truncateFromIndex = prevIndex + 5L;
        this.terms.truncate(truncateFromIndex);
        this.appendRange(truncateFromIndex, truncateFromIndex + 20L, term + 20L);
        this.assertTermInRange(prevIndex + 1L, truncateFromIndex, term);
        this.assertTermInRange(truncateFromIndex, truncateFromIndex + 20L, term + 20L);
    }

    @Test
    public void shouldAppendAfterSkip() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        long skipIndex = 30L;
        long skipTerm = term + 2L;
        this.terms.skip(skipIndex, skipTerm);
        this.assertTermInRange(prevIndex, skipIndex, -1L);
        Assert.assertEquals((long)skipTerm, (long)this.terms.get(skipIndex));
        this.appendRange(skipIndex + 1L, skipIndex + 20L, skipTerm);
        this.assertTermInRange(skipIndex + 1L, skipIndex + 20L, skipTerm);
    }

    @Test
    public void shouldNotPruneAnythingIfBeforeMin() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)2L, (long)this.getIndexesSize());
        Assert.assertEquals((long)2L, (long)this.getTermsSize());
        this.terms.prune(prevIndex);
        this.assertTermInRange(prevIndex - 10L, prevIndex, -1L);
        this.assertTermInRange(prevIndex, prevIndex + 10L, term);
        this.assertTermInRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)2L, (long)this.getIndexesSize());
        Assert.assertEquals((long)2L, (long)this.getTermsSize());
    }

    @Test
    public void shouldPruneInMiddleOfFirstRange() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)2L, (long)this.getIndexesSize());
        Assert.assertEquals((long)2L, (long)this.getTermsSize());
        long pruneIndex = prevIndex + 5L;
        this.terms.prune(pruneIndex);
        this.assertTermInRange(prevIndex - 10L, pruneIndex, -1L);
        this.assertTermInRange(pruneIndex, prevIndex + 10L, term);
        this.assertTermInRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)2L, (long)this.getIndexesSize());
        Assert.assertEquals((long)2L, (long)this.getTermsSize());
    }

    @Test
    public void shouldPruneAtBoundaryOfRange() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)2L, (long)this.getIndexesSize());
        Assert.assertEquals((long)2L, (long)this.getTermsSize());
        long pruneIndex = prevIndex + 10L;
        this.terms.prune(pruneIndex);
        this.assertTermInRange(prevIndex - 10L, pruneIndex, -1L);
        this.assertTermInRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)1L, (long)this.getIndexesSize());
        Assert.assertEquals((long)1L, (long)this.getTermsSize());
    }

    @Test
    public void shouldPruneJustBeyondBoundaryOfRange() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)2L, (long)this.getIndexesSize());
        Assert.assertEquals((long)2L, (long)this.getTermsSize());
        long pruneIndex = prevIndex + 11L;
        this.terms.prune(pruneIndex);
        this.assertTermInRange(prevIndex - 10L, pruneIndex, -1L);
        this.assertTermInRange(prevIndex + 11L, prevIndex + 20L, term + 1L);
        Assert.assertEquals((long)1L, (long)this.getIndexesSize());
        Assert.assertEquals((long)1L, (long)this.getTermsSize());
    }

    @Test
    public void shouldPruneSeveralCompleteRanges() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.appendRange(prevIndex + 1L, prevIndex + 10L, term);
        this.appendRange(prevIndex + 10L, prevIndex + 20L, term + 1L);
        this.appendRange(prevIndex + 20L, prevIndex + 30L, term + 2L);
        this.appendRange(prevIndex + 30L, prevIndex + 40L, term + 3L);
        this.appendRange(prevIndex + 40L, prevIndex + 50L, term + 4L);
        Assert.assertEquals((long)5L, (long)this.getIndexesSize());
        Assert.assertEquals((long)5L, (long)this.getTermsSize());
        long pruneIndex = prevIndex + 25L;
        this.terms.prune(pruneIndex);
        this.assertTermInRange(prevIndex - 10L, pruneIndex, -1L);
        this.assertTermInRange(pruneIndex, prevIndex + 30L, term + 2L);
        this.assertTermInRange(prevIndex + 30L, prevIndex + 40L, term + 3L);
        this.assertTermInRange(prevIndex + 40L, prevIndex + 50L, term + 4L);
        Assert.assertEquals((long)3L, (long)this.getIndexesSize());
        Assert.assertEquals((long)3L, (long)this.getTermsSize());
    }

    @Test
    public void shouldAppendNewItemsIfThereAreNoEntries() throws Exception {
        long term = 5L;
        long prevIndex = 10L;
        this.terms = new Terms(prevIndex, term);
        this.terms.truncate(prevIndex);
        Assert.assertEquals((long)-1L, (long)this.terms.get(prevIndex));
        Assert.assertEquals((long)-1L, (long)this.terms.latest());
        Assert.assertEquals((long)0L, (long)this.getIndexesSize());
        Assert.assertEquals((long)0L, (long)this.getTermsSize());
        this.terms.append(prevIndex, 5L);
        Assert.assertEquals((long)term, (long)this.terms.get(prevIndex));
        Assert.assertEquals((long)term, (long)this.terms.latest());
        Assert.assertEquals((long)1L, (long)this.getIndexesSize());
        Assert.assertEquals((long)1L, (long)this.getTermsSize());
    }

    private int getTermsSize() throws NoSuchFieldException, IllegalAccessException {
        return this.getField("terms");
    }

    private int getIndexesSize() throws NoSuchFieldException, IllegalAccessException {
        return this.getField("indexes");
    }

    private int getField(String name) throws NoSuchFieldException, IllegalAccessException {
        Field field = Terms.class.getDeclaredField(name);
        field.setAccessible(true);
        long[] longs = (long[])field.get(this.terms);
        return longs.length;
    }

    private void assertTermInRange(long from, long to, long expectedTerm) {
        this.assertTermInRange(from, to, index -> expectedTerm);
    }

    private void assertTermInRange(long from, long to, Function<Long, Long> expectedTermFunction) {
        for (long index = from; index < to; ++index) {
            Assert.assertEquals((String)("For index: " + index), (long)expectedTermFunction.apply(index), (long)this.terms.get(index));
        }
    }

    private void appendRange(long from, long to, long term) {
        this.appendRange(from, to, index -> term);
    }

    private void appendRange(long from, long to, Function<Long, Long> termFunction) {
        for (long index = from; index < to; ++index) {
            this.terms.append(index, termFunction.apply(index).longValue());
        }
    }
}

