/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogRotationTest {
    private static final int ROTATE_AT_SIZE_IN_BYTES = 100;
    private final TestDirectory testDirectory = TestDirectory.testDirectory();
    private final LifeRule life = new LifeRule(true);
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDirectory).around((TestRule)this.fileSystemRule).around((TestRule)this.life);

    @Test
    public void shouldRotateOnAppendWhenRotateSizeIsReached() throws Exception {
        SegmentedRaftLog log = (SegmentedRaftLog)this.life.add((Lifecycle)this.createRaftLog(100L));
        log.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)this.replicatedStringOfBytes(100))});
        File[] files = this.fileSystemRule.get().listFiles(this.testDirectory.directory());
        Assert.assertEquals((long)2L, (long)files.length);
    }

    @Test
    public void shouldBeAbleToRecoverToLatestStateAfterRotation() throws Throwable {
        long indexToRestoreTo;
        int term = 0;
        try (Lifespan lifespan = new Lifespan(new Lifecycle[0]);){
            SegmentedRaftLog log = (SegmentedRaftLog)lifespan.add((Lifecycle)this.createRaftLog(100L));
            log.append(new RaftLogEntry[]{new RaftLogEntry((long)term, (ReplicatedContent)this.replicatedStringOfBytes(60))});
            indexToRestoreTo = log.append(new RaftLogEntry[]{new RaftLogEntry((long)term, (ReplicatedContent)ReplicatedInteger.valueOf(1))});
        }
        SegmentedRaftLog log = (SegmentedRaftLog)this.life.add((Lifecycle)this.createRaftLog(100L));
        Assert.assertEquals((long)indexToRestoreTo, (long)log.appendIndex());
        Assert.assertEquals((long)term, (long)log.readEntryTerm(indexToRestoreTo));
    }

    private ReplicatedString replicatedStringOfBytes(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append("i");
        }
        return new ReplicatedString(builder.toString());
    }

    private SegmentedRaftLog createRaftLog(long rotateAtSize) throws IOException {
        NullLogProvider logProvider = NullLogProvider.getInstance();
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory(CausalClusteringSettings.raft_log_pruning_strategy.getDefaultValue(), (LogProvider)logProvider).newInstance();
        return new SegmentedRaftLog((FileSystemAbstraction)this.fileSystemRule.get(), this.testDirectory.directory(), rotateAtSize, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, 0, (Clock)Clocks.fakeClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy);
    }
}

