/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.time.Clock;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.log.ConcurrentStressIT;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategy;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.time.Clocks;

public class SegmentedConcurrentStressIT
extends ConcurrentStressIT<SegmentedRaftLog> {
    @Override
    public SegmentedRaftLog createRaftLog(FileSystemAbstraction fsa, File dir) throws Throwable {
        long rotateAtSize = 0x800000L;
        NullLogProvider logProvider = NullLogProvider.getInstance();
        int readerPoolSize = 8;
        CoreLogPruningStrategy pruningStrategy = new CoreLogPruningStrategyFactory(CausalClusteringSettings.raft_log_pruning_strategy.getDefaultValue(), (LogProvider)logProvider).newInstance();
        SegmentedRaftLog raftLog = new SegmentedRaftLog(fsa, dir, rotateAtSize, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, readerPoolSize, (Clock)Clocks.fakeClock(), (JobScheduler)new OnDemandJobScheduler(), pruningStrategy);
        raftLog.start();
        return raftLog;
    }
}

