/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.kernel.impl.transaction.log.InMemoryClosableChannel;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class SegmentHeaderTest {
    private SegmentHeader.Marshal marshal = new SegmentHeader.Marshal();

    @Test
    public void shouldWriteAndReadHeader() throws Exception {
        long prevFileLastIndex = 1L;
        long version = 2L;
        long prevIndex = 3L;
        long prevTerm = 4L;
        SegmentHeader writtenHeader = new SegmentHeader(prevFileLastIndex, version, prevIndex, prevTerm);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        this.marshal.marshal(writtenHeader, (WritableChannel)channel);
        SegmentHeader readHeader = (SegmentHeader)this.marshal.unmarshal((ReadableChannel)channel);
        Assert.assertEquals((Object)writtenHeader, (Object)readHeader);
    }

    @Test
    public void shouldThrowExceptionWhenReadingIncompleteHeader() throws Exception {
        long prevFileLastIndex = 1L;
        long version = 2L;
        long prevIndex = 3L;
        long prevTerm = 4L;
        SegmentHeader writtenHeader = new SegmentHeader(prevFileLastIndex, version, prevIndex, prevTerm);
        InMemoryClosableChannel channel = new InMemoryClosableChannel();
        channel.putLong(writtenHeader.version());
        channel.putLong(writtenHeader.prevIndex());
        try {
            this.marshal.unmarshal((ReadableChannel)channel);
            Assert.fail();
        }
        catch (EndOfStreamException endOfStreamException) {
            // empty catch block
        }
    }
}

