/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Clock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.EntryRecord;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.causalclustering.core.consensus.log.segmented.Reader;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReaderPool;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentFile;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentHeader;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.cursor.IOCursor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.time.Clocks;

public class SegmentFileTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final File baseDir = new File("raft-log");
    private final FileNames fileNames = new FileNames(this.baseDir);
    private final DummyRaftableContentSerializer contentMarshal = new DummyRaftableContentSerializer();
    private final NullLogProvider logProvider = NullLogProvider.getInstance();
    private final SegmentHeader segmentHeader = new SegmentHeader(-1L, 0L, -1L, -1L);
    private final RaftLogEntry entry1 = new RaftLogEntry(30L, (ReplicatedContent)ReplicatedString.valueOf("contentA"));
    private final RaftLogEntry entry2 = new RaftLogEntry(31L, (ReplicatedContent)ReplicatedString.valueOf("contentB"));
    private final RaftLogEntry entry3 = new RaftLogEntry(32L, (ReplicatedContent)ReplicatedString.valueOf("contentC"));
    private final RaftLogEntry entry4 = new RaftLogEntry(33L, (ReplicatedContent)ReplicatedString.valueOf("contentD"));
    private final int version = 0;
    private ReaderPool readerPool = (ReaderPool)Mockito.spy((Object)new ReaderPool(0, (LogProvider)this.logProvider, this.fileNames, (FileSystemAbstraction)this.fsRule.get(), (Clock)Clocks.fakeClock()));

    @Before
    public void before() {
        this.fsRule.get().mkdirs(this.baseDir);
    }

    @Test
    public void shouldReportCorrectInitialValues() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            Assert.assertEquals((long)0L, (long)segment.header().version());
            IOCursor cursor = segment.getCursor(0L);
            Assert.assertFalse((boolean)cursor.next());
            cursor.close();
        }
    }

    @Test
    public void shouldBeAbleToWriteAndRead() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            segment.write(0L, this.entry1);
            segment.flush();
            IOCursor cursor = segment.getCursor(0L);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((Object)this.entry1, (Object)((EntryRecord)cursor.get()).logEntry());
            cursor.close();
        }
    }

    @Test
    public void shouldBeAbleToReadFromOffset() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            segment.write(0L, this.entry1);
            segment.write(1L, this.entry2);
            segment.write(2L, this.entry3);
            segment.write(3L, this.entry4);
            segment.flush();
            IOCursor cursor = segment.getCursor(2L);
            Assert.assertTrue((boolean)cursor.next());
            Assert.assertEquals((Object)this.entry3, (Object)((EntryRecord)cursor.get()).logEntry());
            cursor.close();
        }
    }

    @Test
    public void shouldBeAbleToRepeatedlyReadWrittenValues() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            segment.write(0L, this.entry1);
            segment.write(1L, this.entry2);
            segment.write(2L, this.entry3);
            segment.flush();
            for (int i = 0; i < 3; ++i) {
                IOCursor cursor = segment.getCursor(0L);
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)this.entry1, (Object)((EntryRecord)cursor.get()).logEntry());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)this.entry2, (Object)((EntryRecord)cursor.get()).logEntry());
                Assert.assertTrue((boolean)cursor.next());
                Assert.assertEquals((Object)this.entry3, (Object)((EntryRecord)cursor.get()).logEntry());
                Assert.assertFalse((boolean)cursor.next());
                cursor.close();
            }
        }
    }

    @Test
    public void shouldBeAbleToCloseOnlyAfterWriterIsClosed() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            Assert.assertFalse((boolean)segment.tryClose());
            segment.closeWriter();
            Assert.assertTrue((boolean)segment.tryClose());
        }
    }

    @Test
    public void shouldCallDisposeHandlerAfterLastReaderIsClosed() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            IOCursor cursor0 = segment.getCursor(0L);
            IOCursor cursor1 = segment.getCursor(0L);
            segment.closeWriter();
            cursor0.close();
            Assert.assertFalse((boolean)segment.tryClose());
            cursor1.close();
            Assert.assertTrue((boolean)segment.tryClose());
        }
    }

    @Test
    public void shouldHandleReaderPastEndCorrectly() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            segment.write(0L, this.entry1);
            segment.write(1L, this.entry2);
            segment.flush();
            segment.closeWriter();
            IOCursor cursor = segment.getCursor(3L);
            Assert.assertFalse((boolean)cursor.next());
            cursor.close();
            Assert.assertTrue((boolean)segment.tryClose());
        }
    }

    @Test
    public void shouldHaveIdempotentCloseMethods() throws Exception {
        SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);
        IOCursor cursor = segment.getCursor(0L);
        segment.closeWriter();
        cursor.close();
        Assert.assertTrue((boolean)segment.tryClose());
        segment.close();
        Assert.assertTrue((boolean)segment.tryClose());
        segment.close();
    }

    @Test
    public void shouldCatchDoubleCloseReaderErrors() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            IOCursor cursor = segment.getCursor(0L);
            cursor.close();
            cursor.close();
            Assert.fail((String)"Should have caught double close error");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldNotReturnReaderExperiencingErrorToPool() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        Reader reader = (Reader)Mockito.mock(Reader.class);
        ReaderPool readerPool = (ReaderPool)Mockito.mock(ReaderPool.class);
        Mockito.when((Object)channel.read((ByteBuffer)Matchers.any(ByteBuffer.class))).thenThrow(new Throwable[]{new IOException()});
        Mockito.when((Object)reader.channel()).thenReturn((Object)channel);
        Mockito.when((Object)readerPool.acquire(Matchers.anyLong(), Matchers.anyLong())).thenReturn((Object)reader);
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            IOCursor cursor = segment.getCursor(0L);
            try {
                cursor.next();
                Assert.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            cursor.close();
            ((ReaderPool)Mockito.verify((Object)readerPool, (VerificationMode)Mockito.never())).release(reader);
            ((Reader)Mockito.verify((Object)reader)).close();
        }
    }

    @Test
    public void shouldPruneReaderPoolOnClose() throws Exception {
        try (SegmentFile segment = SegmentFile.create((FileSystemAbstraction)this.fsRule.get(), (File)this.fileNames.getForVersion(0L), (ReaderPool)this.readerPool, (long)0L, (ChannelMarshal)this.contentMarshal, (LogProvider)this.logProvider, (SegmentHeader)this.segmentHeader);){
            segment.write(0L, this.entry1);
            segment.flush();
            segment.closeWriter();
            IOCursor cursor = segment.getCursor(0L);
            cursor.next();
            cursor.close();
        }
        ((ReaderPool)Mockito.verify((Object)this.readerPool)).prune(0L);
    }
}

