/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.segmented.ReferenceCounter;

public class ReferenceCounterTest {
    private ReferenceCounter refCount = new ReferenceCounter();

    @Test
    public void shouldHaveValidInitialBehaviour() throws Exception {
        Assert.assertEquals((long)0L, (long)this.refCount.get());
        Assert.assertTrue((boolean)this.refCount.tryDispose());
    }

    @Test
    public void shouldNotBeAbleToDisposeWhenActive() throws Exception {
        this.refCount.increase();
        Assert.assertFalse((boolean)this.refCount.tryDispose());
    }

    @Test
    public void shouldBeAbleToDisposeInactive() throws Exception {
        this.refCount.increase();
        this.refCount.increase();
        this.refCount.decrease();
        Assert.assertFalse((boolean)this.refCount.tryDispose());
        this.refCount.decrease();
        Assert.assertTrue((boolean)this.refCount.tryDispose());
    }

    @Test
    public void shouldNotGiveReferenceWhenDisposed() throws Exception {
        this.refCount.tryDispose();
        Assert.assertFalse((boolean)this.refCount.increase());
    }

    @Test
    public void shouldAdjustCounterWithReferences() throws Exception {
        this.refCount.increase();
        Assert.assertEquals((long)1L, (long)this.refCount.get());
        this.refCount.increase();
        Assert.assertEquals((long)2L, (long)this.refCount.get());
        this.refCount.decrease();
        Assert.assertEquals((long)1L, (long)this.refCount.get());
        this.refCount.decrease();
        Assert.assertEquals((long)0L, (long)this.refCount.get());
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenDecreasingPastZero() throws Exception {
        this.refCount.increase();
        this.refCount.decrease();
        try {
            this.refCount.decrease();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowIllegalStateExceptionWhenDecreasingOnDisposed() throws Exception {
        this.refCount.tryDispose();
        try {
            this.refCount.decrease();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

