/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;

public class InFlightLogEntriesCacheTest {
    @Test
    public void shouldRegisterAndUnregisterValues() throws Exception {
        InFlightMap entries = new InFlightMap();
        HashMap<Long, Object> logEntryList = new HashMap<Long, Object>();
        logEntryList.put(1L, new Object());
        for (Map.Entry entry : logEntryList.entrySet()) {
            entries.put((Long)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : logEntryList.entrySet()) {
            Object retrieved = entries.get((Long)entry.getKey());
            Assert.assertEquals(entry.getValue(), (Object)retrieved);
        }
        Long unexpected = 2L;
        Object shouldBeNull = entries.get(unexpected);
        Assert.assertNull((Object)shouldBeNull);
        for (Map.Entry entry : logEntryList.entrySet()) {
            boolean wasThere = entries.remove((Long)entry.getKey());
            Assert.assertEquals((Object)true, (Object)wasThere);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotReinsertValues() throws Exception {
        InFlightMap entries = new InFlightMap();
        Object addedObject = new Object();
        entries.put(Long.valueOf(1L), addedObject);
        entries.put(Long.valueOf(1L), addedObject);
    }

    @Test
    public void shouldNotReplaceRegisteredValues() throws Exception {
        InFlightMap cache = new InFlightMap();
        Object first = new Object();
        Object second = new Object();
        try {
            cache.put(Long.valueOf(1L), first);
            cache.put(Long.valueOf(1L), second);
            Assert.fail((String)"Should not allow silent replacement of values");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)first, (Object)cache.get(Long.valueOf(1L)));
        }
    }
}

