/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.log.segmented.FileNames;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;

public class FileNamesTest {
    @Test
    public void shouldProperlyFormatFilenameForVersion() throws Exception {
        File base = new File("base");
        FileNames fileNames = new FileNames(base);
        for (int i = 0; i < 100; ++i) {
            File forVersion = fileNames.getForVersion((long)i);
            Assert.assertEquals((Object)forVersion, (Object)new File(base, "raft.log." + i));
        }
    }

    @Test
    public void shouldWorkCorrectlyOnReasonableDirectoryContents() throws Exception {
        int upper;
        File base = new File("base");
        FileNames fileNames = new FileNames(base);
        FileSystemAbstraction fsa = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Log log = (Log)Mockito.mock(Log.class);
        LinkedList<File> filesPresent = new LinkedList<File>();
        int lower = 0;
        for (int i = upper = 24; i >= lower; --i) {
            filesPresent.add(fileNames.getForVersion((long)i));
        }
        Mockito.when((Object)fsa.listFiles(base)).thenReturn((Object)filesPresent.toArray(new File[0]));
        SortedMap allFiles = fileNames.getAllFiles(fsa, log);
        Assert.assertEquals((long)(upper - lower + 1), (long)allFiles.size());
        long currentVersion = lower;
        for (Map.Entry longFileEntry : allFiles.entrySet()) {
            Assert.assertEquals((long)currentVersion, (long)((Long)longFileEntry.getKey()));
            Assert.assertEquals((Object)fileNames.getForVersion(currentVersion), longFileEntry.getValue());
            ++currentVersion;
        }
    }

    @Test
    public void shouldIgnoreUnexpectedLogDirectoryContents() throws Exception {
        File base = new File("base");
        FileNames fileNames = new FileNames(base);
        FileSystemAbstraction fsa = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Log log = (Log)Mockito.mock(Log.class);
        LinkedList<File> filesPresent = new LinkedList<File>();
        filesPresent.add(fileNames.getForVersion(0L));
        filesPresent.add(fileNames.getForVersion(1L));
        filesPresent.add(fileNames.getForVersion(10L));
        filesPresent.add(fileNames.getForVersion(11L));
        filesPresent.add(new File(base, "raft.log.01"));
        filesPresent.add(new File(base, "raft.log.001"));
        filesPresent.add(new File(base, "raft.log."));
        filesPresent.add(new File(base, "raft.log.-1"));
        filesPresent.add(new File(base, "raft.log.1a"));
        filesPresent.add(new File(base, "raft.log.a1"));
        filesPresent.add(new File(base, "raft.log.ab"));
        Mockito.when((Object)fsa.listFiles(base)).thenReturn((Object)filesPresent.toArray(new File[0]));
        SortedMap allFiles = fileNames.getAllFiles(fsa, log);
        Assert.assertEquals((long)4L, (long)allFiles.size());
        Assert.assertEquals(allFiles.get(0L), (Object)fileNames.getForVersion(0L));
        Assert.assertEquals(allFiles.get(1L), (Object)fileNames.getForVersion(1L));
        Assert.assertEquals(allFiles.get(10L), (Object)fileNames.getForVersion(10L));
        Assert.assertEquals(allFiles.get(11L), (Object)fileNames.getForVersion(11L));
        ((Log)Mockito.verify((Object)log, (VerificationMode)Mockito.times((int)7))).warn(Matchers.anyString());
    }
}

