/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.pruning;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.core.consensus.log.pruning.LogPruner;
import org.neo4j.causalclustering.core.consensus.log.pruning.PruningScheduler;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OnDemandJobScheduler;

public class PruningSchedulerTest {
    private final LogPruner logPruner = (LogPruner)Mockito.mock(LogPruner.class);
    private final OnDemandJobScheduler jobScheduler = (OnDemandJobScheduler)Mockito.spy((Object)new OnDemandJobScheduler());

    @Test
    public void shouldScheduleTheCheckPointerJobOnStart() throws Throwable {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        ((OnDemandJobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)1))).schedule((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.raftLogPruning), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)20L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void shouldRescheduleTheJobAfterARun() throws Throwable {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Runnable scheduledJob = this.jobScheduler.getJob();
        Assert.assertNotNull((Object)scheduledJob);
        this.jobScheduler.runJob();
        ((OnDemandJobScheduler)Mockito.verify((Object)this.jobScheduler, (VerificationMode)Mockito.times((int)2))).schedule((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.raftLogPruning), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)20L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((LogPruner)Mockito.verify((Object)this.logPruner, (VerificationMode)Mockito.times((int)1))).prune();
        Assert.assertEquals((Object)scheduledJob, (Object)this.jobScheduler.getJob());
    }

    @Test
    public void shouldNotRescheduleAJobWhenStopped() throws Throwable {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        scheduler.stop();
        Assert.assertNull((Object)this.jobScheduler.getJob());
    }

    @Test
    public void stoppedJobCantBeInvoked() throws Throwable {
        PruningScheduler scheduler = new PruningScheduler(this.logPruner, (JobScheduler)this.jobScheduler, 10L, (LogProvider)NullLogProvider.getInstance());
        scheduler.start();
        this.jobScheduler.runJob();
        ((LogPruner)Mockito.verify((Object)this.logPruner)).prune();
        scheduler.stop();
        scheduler.start();
        this.jobScheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.logPruner});
    }

    @Test
    public void shouldWaitOnStopUntilTheRunningCheckpointIsDone() throws Throwable {
        final AtomicReference ex = new AtomicReference();
        final AtomicBoolean stoppedCompleted = new AtomicBoolean();
        DoubleLatch checkPointerLatch = new DoubleLatch(1);
        LogPruner logPruner = () -> {
            checkPointerLatch.startAndWaitForAllToStart();
            checkPointerLatch.waitForAllToFinish();
        };
        final PruningScheduler scheduler = new PruningScheduler(logPruner, (JobScheduler)this.jobScheduler, 20L, (LogProvider)NullLogProvider.getInstance());
        scheduler.start();
        Thread runCheckPointer = new Thread(){

            @Override
            public void run() {
                PruningSchedulerTest.this.jobScheduler.runJob();
            }
        };
        runCheckPointer.start();
        checkPointerLatch.waitForAllToStart();
        Thread stopper = new Thread(){

            @Override
            public void run() {
                try {
                    scheduler.stop();
                    stoppedCompleted.set(true);
                }
                catch (Throwable throwable) {
                    ex.set(throwable);
                }
            }
        };
        stopper.start();
        Thread.sleep(10L);
        Assert.assertFalse((boolean)stoppedCompleted.get());
        checkPointerLatch.finish();
        runCheckPointer.join();
        Thread.sleep(150L);
        Assert.assertTrue((boolean)stoppedCompleted.get());
        stopper.join();
        Assert.assertNull(ex.get());
    }
}

