/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.File;
import java.io.IOException;
import java.time.Clock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.ReplicatedString;
import org.neo4j.causalclustering.core.consensus.log.DummyRaftableContentSerializer;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.CoreLogPruningStrategyFactory;
import org.neo4j.causalclustering.core.consensus.log.segmented.SegmentedRaftLog;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.ChannelMarshal;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.OnDemandJobScheduler;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;
import org.neo4j.time.Clocks;

public class SegmentedRaftLogDurabilityTest {
    @Rule
    public final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    private final RaftLogFactory logFactory = fileSystem -> {
        File directory = new File("raft-log");
        fileSystem.mkdir(directory);
        long rotateAtSizeBytes = 128L;
        int readerPoolSize = 8;
        NullLogProvider logProvider = NullLogProvider.getInstance();
        SegmentedRaftLog log = new SegmentedRaftLog(fileSystem, directory, rotateAtSizeBytes, (ChannelMarshal)new DummyRaftableContentSerializer(), (LogProvider)logProvider, readerPoolSize, (Clock)Clocks.fakeClock(), (JobScheduler)new OnDemandJobScheduler(), new CoreLogPruningStrategyFactory("1 size", (LogProvider)logProvider).newInstance());
        log.start();
        return log;
    };

    @Test
    public void shouldAppendDataAndNotCommitImmediately() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntry = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        log.append(new RaftLogEntry[]{logEntry});
        this.verifyCurrentLogAndNewLogLoadedFromFileSystem(log, this.fsRule.get(), myLog -> {
            MatcherAssert.assertThat((Object)myLog.appendIndex(), (Matcher)CoreMatchers.is((Object)0L));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntry));
        });
    }

    @Test
    public void shouldAppendAndCommit() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntry = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        log.append(new RaftLogEntry[]{logEntry});
        this.verifyCurrentLogAndNewLogLoadedFromFileSystem(log, this.fsRule.get(), myLog -> MatcherAssert.assertThat((Object)myLog.appendIndex(), (Matcher)CoreMatchers.is((Object)0L)));
    }

    @Test
    public void shouldAppendAfterReloadingFromFileSystem() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        log.append(new RaftLogEntry[]{logEntryA});
        this.fsRule.get().crash();
        log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2));
        log.append(new RaftLogEntry[]{logEntryB});
        MatcherAssert.assertThat((Object)log.appendIndex(), (Matcher)CoreMatchers.is((Object)1L));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 0L), (Matcher)CoreMatchers.is((Object)logEntryA));
        MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)log, 1L), (Matcher)CoreMatchers.is((Object)logEntryB));
    }

    @Test
    public void shouldTruncatePreviouslyAppendedEntries() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2));
        log.append(new RaftLogEntry[]{logEntryA});
        log.append(new RaftLogEntry[]{logEntryB});
        log.truncate(1L);
        this.verifyCurrentLogAndNewLogLoadedFromFileSystem(log, this.fsRule.get(), myLog -> MatcherAssert.assertThat((Object)myLog.appendIndex(), (Matcher)CoreMatchers.is((Object)0L)));
    }

    @Test
    public void shouldReplacePreviouslyAppendedEntries() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(2));
        RaftLogEntry logEntryC = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(3));
        RaftLogEntry logEntryD = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(4));
        RaftLogEntry logEntryE = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(5));
        log.append(new RaftLogEntry[]{logEntryA});
        log.append(new RaftLogEntry[]{logEntryB});
        log.append(new RaftLogEntry[]{logEntryC});
        log.truncate(1L);
        log.append(new RaftLogEntry[]{logEntryD});
        log.append(new RaftLogEntry[]{logEntryE});
        this.verifyCurrentLogAndNewLogLoadedFromFileSystem(log, this.fsRule.get(), myLog -> {
            MatcherAssert.assertThat((Object)myLog.appendIndex(), (Matcher)CoreMatchers.is((Object)2L));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntryA));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, 1L), (Matcher)CoreMatchers.equalTo((Object)logEntryD));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, 2L), (Matcher)CoreMatchers.equalTo((Object)logEntryE));
        });
    }

    @Test
    public void shouldLogDifferentContentTypes() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        RaftLogEntry logEntryA = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedInteger.valueOf(1));
        RaftLogEntry logEntryB = new RaftLogEntry(1L, (ReplicatedContent)ReplicatedString.valueOf("hejzxcjkzhxcjkxz"));
        log.append(new RaftLogEntry[]{logEntryA});
        log.append(new RaftLogEntry[]{logEntryB});
        this.verifyCurrentLogAndNewLogLoadedFromFileSystem(log, this.fsRule.get(), myLog -> {
            MatcherAssert.assertThat((Object)myLog.appendIndex(), (Matcher)CoreMatchers.is((Object)1L));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, 0L), (Matcher)CoreMatchers.equalTo((Object)logEntryA));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, 1L), (Matcher)CoreMatchers.equalTo((Object)logEntryB));
        });
    }

    @Test
    public void shouldRecoverAfterEventuallyPruning() throws Exception {
        RaftLog log = this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get());
        long term = 0L;
        long prunedIndex = -1L;
        int val = 0;
        while (prunedIndex == -1L) {
            for (int i = 0; i < 100; ++i) {
                log.append(new RaftLogEntry[]{new RaftLogEntry(term, (ReplicatedContent)ReplicatedInteger.valueOf(val++))});
            }
            long safeIndex = log.appendIndex() - 50L;
            prunedIndex = log.prune(safeIndex);
        }
        long finalAppendIndex = log.appendIndex();
        long finalPrunedIndex = prunedIndex;
        this.verifyCurrentLogAndNewLogLoadedFromFileSystem(log, this.fsRule.get(), myLog -> {
            MatcherAssert.assertThat((Object)log, RaftLogHelper.hasNoContent(0L));
            MatcherAssert.assertThat((Object)log, RaftLogHelper.hasNoContent(finalPrunedIndex));
            MatcherAssert.assertThat((Object)myLog.prevIndex(), (Matcher)CoreMatchers.equalTo((Object)finalPrunedIndex));
            MatcherAssert.assertThat((Object)myLog.appendIndex(), (Matcher)CoreMatchers.is((Object)finalAppendIndex));
            MatcherAssert.assertThat((Object)RaftLogHelper.readLogEntry((ReadableRaftLog)myLog, finalPrunedIndex + 1L).content(), (Matcher)CoreMatchers.equalTo((Object)ReplicatedInteger.valueOf((int)finalPrunedIndex + 1)));
        });
    }

    private void verifyCurrentLogAndNewLogLoadedFromFileSystem(RaftLog log, EphemeralFileSystemAbstraction fileSystem, LogVerifier logVerifier) throws Exception {
        logVerifier.verifyLog(log);
        logVerifier.verifyLog(this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get()));
        fileSystem.crash();
        logVerifier.verifyLog(this.logFactory.createBasedOn((FileSystemAbstraction)this.fsRule.get()));
    }

    private static interface LogVerifier {
        public void verifyLog(RaftLog var1) throws IOException;
    }

    private static interface RaftLogFactory {
        public RaftLog createBasedOn(FileSystemAbstraction var1) throws Exception;
    }
}

