/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.log.RaftLogMetadataCache;
import org.neo4j.kernel.impl.transaction.log.LogPosition;

public class RaftLogMetadataCacheTest {
    @Test
    public void shouldReturnNullWhenMissingAnEntryInTheCache() {
        RaftLogMetadataCache cache = new RaftLogMetadataCache(2);
        RaftLogMetadataCache.RaftLogEntryMetadata metadata = cache.getMetadata(42L);
        Assert.assertNull((Object)metadata);
    }

    @Test
    public void shouldReturnTheTxValueTIfInTheCached() {
        RaftLogMetadataCache cache = new RaftLogMetadataCache(2);
        long index = 12L;
        long term = 12L;
        LogPosition position = new LogPosition(3L, 4L);
        cache.cacheMetadata(12L, 12L, position);
        RaftLogMetadataCache.RaftLogEntryMetadata metadata = cache.getMetadata(12L);
        Assert.assertEquals((Object)new RaftLogMetadataCache.RaftLogEntryMetadata(12L, position), (Object)metadata);
    }

    @Test
    public void shouldClearTheCache() {
        RaftLogMetadataCache cache = new RaftLogMetadataCache(2);
        long index = 12L;
        long term = 12L;
        LogPosition position = new LogPosition(3L, 4L);
        cache.cacheMetadata(12L, 12L, position);
        cache.clear();
        RaftLogMetadataCache.RaftLogEntryMetadata metadata = cache.getMetadata(12L);
        Assert.assertNull((Object)metadata);
    }

    @Test
    public void shouldRemoveUpTo() throws Exception {
        long i;
        int cacheSize = 100;
        RaftLogMetadataCache cache = new RaftLogMetadataCache(cacheSize);
        for (int i2 = 0; i2 < cacheSize; ++i2) {
            cache.cacheMetadata((long)i2, (long)i2, new LogPosition((long)i2, (long)i2));
        }
        int upTo = 30;
        cache.removeUpTo((long)upTo);
        for (i = 0L; i <= (long)upTo; ++i) {
            Assert.assertNull((Object)cache.getMetadata(i));
        }
        while (i < (long)cacheSize) {
            RaftLogMetadataCache.RaftLogEntryMetadata metadata = cache.getMetadata(i);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)i, (long)metadata.getEntryTerm());
            ++i;
        }
    }

    @Test
    public void shouldRemoveUpwardsFrom() throws Exception {
        long i;
        int cacheSize = 100;
        RaftLogMetadataCache cache = new RaftLogMetadataCache(cacheSize);
        for (int i2 = 0; i2 < cacheSize; ++i2) {
            cache.cacheMetadata((long)i2, (long)i2, new LogPosition((long)i2, (long)i2));
        }
        int upFrom = 60;
        cache.removeUpwardsFrom((long)upFrom);
        for (i = 0L; i < (long)upFrom; ++i) {
            RaftLogMetadataCache.RaftLogEntryMetadata metadata = cache.getMetadata(i);
            Assert.assertNotNull((Object)metadata);
            Assert.assertEquals((long)i, (long)metadata.getEntryTerm());
        }
        while (i < (long)cacheSize) {
            Assert.assertNull((Object)cache.getMetadata(i));
            ++i;
        }
    }

    @Test
    public void shouldAcceptAndReturnIndexesInRangeJustDeleted() throws Exception {
        int i;
        int cacheSize = 100;
        RaftLogMetadataCache cache = new RaftLogMetadataCache(cacheSize);
        for (int i2 = 0; i2 < cacheSize; ++i2) {
            cache.cacheMetadata((long)i2, (long)i2, new LogPosition((long)i2, (long)i2));
        }
        int upFrom = 60;
        cache.removeUpwardsFrom((long)upFrom);
        int insertedIndex = 70;
        long insertedTerm = 150L;
        cache.cacheMetadata((long)insertedIndex, insertedTerm, new LogPosition((long)insertedIndex, (long)insertedIndex));
        for (i = upFrom; i < insertedIndex; ++i) {
            Assert.assertNull((Object)cache.getMetadata((long)i));
        }
        Assert.assertEquals((long)insertedTerm, (long)cache.getMetadata((long)i).getEntryTerm());
        ++i;
        while (i < cacheSize) {
            Assert.assertNull((Object)cache.getMetadata((long)i));
            ++i;
        }
    }
}

