/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.explorer;

import java.io.IOException;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.explorer.ComparableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.log.segmented.InFlightMap;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.outcome.RaftLogCommand;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class ComparableRaftState
implements ReadableRaftState {
    protected final MemberId myself;
    private final Set votingMembers;
    private final Set replicationMembers;
    private final Log log;
    protected long term = 0L;
    protected MemberId leader;
    private long leaderCommit = -1L;
    private MemberId votedFor = null;
    private Set votesForMe = new HashSet();
    private long lastLogIndexBeforeWeBecameLeader = -1L;
    private FollowerStates followerStates = new FollowerStates();
    protected final RaftLog entryLog;
    private final InFlightMap<RaftLogEntry> inFlightMap;
    private long commitIndex = -1L;

    ComparableRaftState(MemberId myself, Set votingMembers, Set replicationMembers, RaftLog entryLog, InFlightMap<RaftLogEntry> inFlightMap, LogProvider logProvider) {
        this.myself = myself;
        this.votingMembers = votingMembers;
        this.replicationMembers = replicationMembers;
        this.entryLog = entryLog;
        this.inFlightMap = inFlightMap;
        this.log = logProvider.getLog(this.getClass());
    }

    public ComparableRaftState(ReadableRaftState original) throws IOException {
        this(original.myself(), original.votingMembers(), original.replicationMembers(), (RaftLog)new ComparableRaftLog(original.entryLog()), (InFlightMap<RaftLogEntry>)new InFlightMap(), (LogProvider)NullLogProvider.getInstance());
    }

    public MemberId myself() {
        return this.myself;
    }

    public Set votingMembers() {
        return this.votingMembers;
    }

    public Set replicationMembers() {
        return this.replicationMembers;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return this.leader;
    }

    public long leaderCommit() {
        return 0L;
    }

    public MemberId votedFor() {
        return this.votedFor;
    }

    public Set votesForMe() {
        return this.votesForMe;
    }

    public long lastLogIndexBeforeWeBecameLeader() {
        return this.lastLogIndexBeforeWeBecameLeader;
    }

    public FollowerStates followerStates() {
        return this.followerStates;
    }

    public ReadableRaftLog entryLog() {
        return this.entryLog;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public void update(Outcome outcome) throws IOException {
        this.term = outcome.getTerm();
        this.votedFor = outcome.getVotedFor();
        this.leader = outcome.getLeader();
        this.votesForMe = outcome.getVotesForMe();
        this.lastLogIndexBeforeWeBecameLeader = outcome.getLastLogIndexBeforeWeBecameLeader();
        this.followerStates = outcome.getFollowerStates();
        for (RaftLogCommand logCommand : outcome.getLogCommands()) {
            logCommand.applyTo(this.entryLog, this.log);
            logCommand.applyTo(this.inFlightMap, this.log);
        }
        this.commitIndex = outcome.getCommitIndex();
    }

    public String toString() {
        return String.format("state{myself=%s, term=%s, leader=%s, leaderCommit=%d, appended=%d, committed=%d, votedFor=%s, votesForMe=%s, lastLogIndexBeforeWeBecameLeader=%d, followerStates=%s}", this.myself, this.term, this.leader, this.leaderCommit, this.entryLog.appendIndex(), this.commitIndex, this.votedFor, this.votesForMe, this.lastLogIndexBeforeWeBecameLeader, this.followerStates);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableRaftState that = (ComparableRaftState)o;
        return Objects.equals(this.term, that.term) && Objects.equals(this.lastLogIndexBeforeWeBecameLeader, that.lastLogIndexBeforeWeBecameLeader) && Objects.equals(this.myself, that.myself) && Objects.equals(this.votingMembers, that.votingMembers) && Objects.equals(this.leader, that.leader) && Objects.equals(this.leaderCommit, that.leaderCommit) && Objects.equals(this.entryLog, that.entryLog) && Objects.equals(this.votedFor, that.votedFor) && Objects.equals(this.votesForMe, that.votesForMe) && Objects.equals(this.followerStates, that.followerStates);
    }

    public int hashCode() {
        return Objects.hash(this.myself, this.votingMembers, this.term, this.leader, this.entryLog, this.votedFor, this.votesForMe, this.lastLogIndexBeforeWeBecameLeader, this.followerStates);
    }
}

