/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.explorer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.neo4j.causalclustering.core.consensus.RaftMessageHandler;
import org.neo4j.causalclustering.core.consensus.explorer.ClusterState;
import org.neo4j.causalclustering.core.consensus.explorer.ComparableRaftState;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.roles.Leader;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.identity.MemberId;

public class ClusterSafetyViolations {
    public static List<Violation> violations(ClusterState state) throws IOException {
        ArrayList<Violation> invariantsViolated = new ArrayList<Violation>();
        if (ClusterSafetyViolations.multipleLeadersInSameTerm(state)) {
            invariantsViolated.add(Violation.MULTIPLE_LEADERS);
        }
        if (ClusterSafetyViolations.inconsistentCommittedLogEntries(state)) {
            invariantsViolated.add(Violation.DIVERGED_LOG);
        }
        return invariantsViolated;
    }

    public static boolean inconsistentCommittedLogEntries(ClusterState state) throws IOException {
        int index = 0;
        boolean moreLog = true;
        while (moreLog) {
            moreLog = false;
            RaftLogEntry clusterLogEntry = null;
            for (ComparableRaftState memberState : state.states.values()) {
                if ((long)index <= memberState.commitIndex()) {
                    RaftLogEntry memberLogEntry = RaftLogHelper.readLogEntry(memberState.entryLog(), index);
                    if (clusterLogEntry == null) {
                        clusterLogEntry = memberLogEntry;
                    } else if (!clusterLogEntry.equals((Object)memberLogEntry)) {
                        return true;
                    }
                }
                if ((long)index >= memberState.commitIndex()) continue;
                moreLog = true;
            }
            ++index;
        }
        return false;
    }

    public static boolean multipleLeadersInSameTerm(ClusterState state) {
        HashSet<Long> termThatHaveALeader = new HashSet<Long>();
        for (Map.Entry<MemberId, Role> entry : state.roles.entrySet()) {
            RaftMessageHandler role = entry.getValue().handler;
            if (!(role instanceof Leader)) continue;
            long term = state.states.get(entry.getKey()).term();
            if (termThatHaveALeader.contains(term)) {
                return true;
            }
            termThatHaveALeader.add(term);
        }
        return false;
    }

    public static enum Violation {
        DIVERGED_LOG,
        MULTIPLE_LEADERS;

    }
}

