/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.election;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMachineBuilder;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.schedule.DelayedRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;
import org.neo4j.causalclustering.messaging.TestNetwork;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.time.Clocks;

public class Fixture {
    private final Set<MemberId> members = new HashSet<MemberId>();
    private final Set<BootstrapWaiter> bootstrapWaiters = new HashSet<BootstrapWaiter>();
    private final List<DelayedRenewableTimeoutService> timeoutServices = new ArrayList<DelayedRenewableTimeoutService>();
    final Set<RaftFixture> rafts = new HashSet<RaftFixture>();
    final TestNetwork net;

    Fixture(Set<MemberId> memberIds, TestNetwork net, long electionTimeout, long heartbeatInterval) {
        this.net = net;
        for (MemberId member : memberIds) {
            TestNetwork testNetwork = net;
            testNetwork.getClass();
            TestNetwork.Inbound inbound = testNetwork.new TestNetwork.Inbound(member);
            TestNetwork testNetwork2 = net;
            testNetwork2.getClass();
            TestNetwork.Outbound outbound = testNetwork2.new TestNetwork.Outbound(member);
            this.members.add(member);
            DelayedRenewableTimeoutService timeoutService = this.createTimeoutService();
            BootstrapWaiter waiter = new BootstrapWaiter();
            this.bootstrapWaiters.add(waiter);
            InMemoryRaftLog raftLog = new InMemoryRaftLog();
            RaftMachine raftMachine = new RaftMachineBuilder(member, memberIds.size(), RaftTestMemberSetBuilder.INSTANCE).electionTimeout(electionTimeout).heartbeatInterval(heartbeatInterval).inbound(inbound).outbound(outbound).timeoutService((RenewableTimeoutService)timeoutService).raftLog((RaftLog)raftLog).commitListener(waiter).build();
            this.rafts.add(new RaftFixture(raftMachine, raftLog));
        }
    }

    private DelayedRenewableTimeoutService createTimeoutService() {
        DelayedRenewableTimeoutService timeoutService = new DelayedRenewableTimeoutService(Clocks.systemClock(), (LogProvider)NullLogProvider.getInstance());
        this.timeoutServices.add(timeoutService);
        timeoutService.init();
        timeoutService.start();
        return timeoutService;
    }

    void boot() throws RaftMachine.BootstrapException, TimeoutException, InterruptedException, IOException {
        for (RaftFixture raft : this.rafts) {
            raft.raftLog().append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new MemberIdSet(Iterables.asSet(this.members)))});
            raft.raftMachine().installCoreState(new RaftCoreState(new MembershipEntry(0L, this.members)));
        }
        this.net.start();
        this.awaitBootstrapped();
    }

    public void tearDown() {
        this.net.stop();
        for (DelayedRenewableTimeoutService timeoutService : this.timeoutServices) {
            try {
                timeoutService.stop();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        for (RaftFixture raft : this.rafts) {
            raft.raftMachine().logShippingManager().stop();
        }
    }

    private void awaitBootstrapped() throws InterruptedException, TimeoutException {
        Predicates.await(() -> {
            for (BootstrapWaiter bootstrapWaiter : this.bootstrapWaiters) {
                if (bootstrapWaiter.bootstrapped.get()) continue;
                return false;
            }
            return true;
        }, (long)30L, (TimeUnit)TimeUnit.SECONDS, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    class RaftFixture {
        private final RaftMachine raftMachine;
        private final InMemoryRaftLog raftLog;

        public RaftFixture(RaftMachine raftMachine, InMemoryRaftLog raftLog) {
            this.raftMachine = raftMachine;
            this.raftLog = raftLog;
        }

        public RaftMachine raftMachine() {
            return this.raftMachine;
        }

        public InMemoryRaftLog raftLog() {
            return this.raftLog;
        }
    }

    private static class BootstrapWaiter
    implements RaftMachineBuilder.CommitListener {
        private AtomicBoolean bootstrapped = new AtomicBoolean(false);

        private BootstrapWaiter() {
        }

        @Override
        public void notifyCommitted(long commitIndex) {
            if (commitIndex >= 0L) {
                this.bootstrapped.set(true);
            }
        }
    }
}

