/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.election;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.util.Listener;

public class ElectionUtil {
    public static MemberId waitForLeaderAgreement(Iterable<RaftMachine> validRafts, long maxTimeMillis) throws InterruptedException, TimeoutException {
        long viewCount = Iterables.count(validRafts);
        HashMap<MemberId, MemberId> leaderViews = new HashMap<MemberId, MemberId>();
        CompletableFuture<MemberId> futureAgreedLeader = new CompletableFuture<MemberId>();
        ArrayList<Runnable> destructors = new ArrayList<Runnable>();
        for (RaftMachine raft : validRafts) {
            destructors.add(ElectionUtil.leaderViewUpdatingListener(raft, validRafts, leaderViews, viewCount, futureAgreedLeader));
        }
        try {
            MemberId memberId = (MemberId)futureAgreedLeader.get(maxTimeMillis, TimeUnit.MILLISECONDS);
            return memberId;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            destructors.forEach(Runnable::run);
        }
    }

    private static Runnable leaderViewUpdatingListener(RaftMachine raft, Iterable<RaftMachine> validRafts, Map<MemberId, MemberId> leaderViews, long viewCount, CompletableFuture<MemberId> futureAgreedLeader) {
        Listener listener = newLeader -> {
            Map map = leaderViews;
            synchronized (map) {
                leaderViews.put(raft.identity(), (MemberId)newLeader);
                boolean leaderIsValid = false;
                for (RaftMachine validRaft : validRafts) {
                    if (!validRaft.identity().equals(newLeader)) continue;
                    leaderIsValid = true;
                }
                if (newLeader != null && leaderIsValid && ElectionUtil.allAgreeOnLeader(leaderViews, viewCount, newLeader)) {
                    futureAgreedLeader.complete((MemberId)newLeader);
                }
            }
        };
        raft.registerListener(listener);
        return () -> raft.unregisterListener(listener);
    }

    private static <T> boolean allAgreeOnLeader(Map<T, T> leaderViews, long viewCount, T leader) {
        if ((long)leaderViews.size() != viewCount) {
            return false;
        }
        for (T leaderView : leaderViews.values()) {
            if (leader.equals(leaderView)) continue;
            return false;
        }
        return true;
    }
}

