/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.election;

import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.election.DisconnectLeaderScenario;
import org.neo4j.causalclustering.core.consensus.election.Fixture;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.messaging.TestNetwork;
import org.neo4j.helpers.collection.Iterators;

public class ElectionPerformanceIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void electionPerformance_NormalConditions() throws Throwable {
        long networkLatency = 15L;
        long electionTimeout = 500L;
        long heartbeatInterval = 250L;
        int iterations = 10;
        TestNetwork<Object> net = new TestNetwork<Object>((i, o) -> 15L);
        Set members = Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)});
        Fixture fixture = new Fixture(members, net, 500L, 250L);
        DisconnectLeaderScenario scenario = new DisconnectLeaderScenario(fixture, 500L);
        try {
            fixture.boot();
            scenario.run(10L, 5000L);
        }
        finally {
            fixture.tearDown();
        }
        DisconnectLeaderScenario.Result result = scenario.result();
        MatcherAssert.assertThat((Object)result.nonCollidingAverage, (Matcher)Matchers.lessThan((Comparable)Double.valueOf(1000.0)));
        if (result.collisionCount > 3L) {
            MatcherAssert.assertThat((Object)result.collidingAverage, (Matcher)Matchers.lessThan((Comparable)Double.valueOf(3000.0)));
        }
        MatcherAssert.assertThat((Object)result.timeoutCount, (Matcher)CoreMatchers.is((Object)0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void electionPerformance_RapidConditions() throws Throwable {
        long networkLatency = 1L;
        long electionTimeout = 30L;
        long heartbeatInterval = 15L;
        int iterations = 100;
        TestNetwork<Object> net = new TestNetwork<Object>((i, o) -> 1L);
        Set members = Iterators.asSet((Object[])new MemberId[]{RaftTestMember.member(0), RaftTestMember.member(1), RaftTestMember.member(2)});
        Fixture fixture = new Fixture(members, net, 30L, 15L);
        DisconnectLeaderScenario scenario = new DisconnectLeaderScenario(fixture, 30L);
        try {
            fixture.boot();
            scenario.run(100L, 300L);
        }
        finally {
            fixture.tearDown();
        }
        DisconnectLeaderScenario.Result result = scenario.result();
        MatcherAssert.assertThat((Object)result.nonCollidingAverage, (Matcher)Matchers.lessThan((Comparable)Double.valueOf(60.0)));
        MatcherAssert.assertThat((Object)result.collisionRate, (Matcher)Matchers.lessThan((Comparable)Double.valueOf(0.5)));
        if (result.collisionCount > 10L) {
            MatcherAssert.assertThat((Object)result.collidingAverage, (Matcher)Matchers.lessThan((Comparable)Double.valueOf(150.0)));
        }
        MatcherAssert.assertThat((Object)result.timeoutCount, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(1L)));
    }
}

