/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.DirectNetworking;
import org.neo4j.causalclustering.core.consensus.LeaderNotFoundMonitor;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.NoLeaderFoundException;
import org.neo4j.causalclustering.core.consensus.OutboundMessageCollector;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMachineBuilder;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.TestMessageBuilders;
import org.neo4j.causalclustering.core.consensus.log.InMemoryRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogCursor;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.schedule.ControlledRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;
import org.neo4j.causalclustering.identity.RaftTestMemberSetBuilder;
import org.neo4j.causalclustering.messaging.Inbound;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.internal.KernelEventHandlers;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class RaftMachineTest {
    private MemberId myself = RaftTestMember.member(0);
    private MemberId member1 = RaftTestMember.member(1);
    private MemberId member2 = RaftTestMember.member(2);
    private MemberId member3 = RaftTestMember.member(3);
    private MemberId member4 = RaftTestMember.member(4);
    private ReplicatedInteger data1 = ReplicatedInteger.valueOf(1);
    private RaftLog raftLog = new InMemoryRaftLog();

    @Test
    public void shouldAlwaysStartAsFollower() throws Exception {
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).build();
        Assert.assertEquals((Object)Role.FOLLOWER, (Object)raft.currentRole());
    }

    @Test
    public void shouldRequestVotesOnElectionTimeout() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        OutboundMessageCollector messages = new OutboundMessageCollector();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).outbound(messages).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        MatcherAssert.assertThat((Object)messages.sentTo(this.myself).size(), (Matcher)CoreMatchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)messages.sentTo(this.member1).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)messages.sentTo(this.member1).get(0), (Matcher)CoreMatchers.instanceOf(RaftMessages.Vote.Request.class));
        MatcherAssert.assertThat((Object)messages.sentTo(this.member2).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)messages.sentTo(this.member2).get(0), (Matcher)CoreMatchers.instanceOf(RaftMessages.Vote.Request.class));
    }

    @Test
    public void shouldBecomeLeaderInMajorityOf3() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldBecomeLeaderInMajorityOf5() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member2).term(1L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBecomeLeaderOnMultipleVotesFromSameMember() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, this.member3, this.member4}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBecomeLeaderWhenVotingOnItself() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.myself).term(1L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBecomeLeaderWhenMembersVoteNo() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).deny().build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member2).term(1L).deny().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotBecomeLeaderByVotesFromOldTerm() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(0L).grant().build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member2).term(0L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldVoteFalseForCandidateInOldTerm() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        OutboundMessageCollector messages = new OutboundMessageCollector();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).outbound(messages).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteRequest().from(this.member1).term(-1L).candidate(this.member1).lastLogIndex(0L).lastLogTerm(-1L).build());
        MatcherAssert.assertThat((Object)messages.sentTo(this.member1).size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat(messages.sentTo(this.member1), (Matcher)CoreMatchers.hasItem((Object)TestMessageBuilders.voteResponse().from(this.myself).term(0L).deny().build()));
    }

    @Test
    public void shouldNotBecomeLeaderByVotesFromFutureTerm() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(2L).grant().build());
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member2).term(2L).grant().build());
        MatcherAssert.assertThat((Object)raft.isLeader(), (Matcher)Is.is((Object)false));
        Assert.assertEquals((long)raft.term(), (long)2L);
    }

    @Test
    public void shouldAppendNewLeaderBarrierAfterBecomingLeader() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        OutboundMessageCollector messages = new OutboundMessageCollector();
        InMemoryRaftLog raftLog = new InMemoryRaftLog();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).outbound(messages).raftLog((RaftLog)raftLog).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        Assert.assertEquals((Object)new NewLeaderBarrier(), (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)raftLog, raftLog.appendIndex()).content());
    }

    @Test
    public void leaderShouldSendHeartBeatsOnHeartbeatTimeout() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        OutboundMessageCollector messages = new OutboundMessageCollector();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).outbound(messages).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        Assert.assertTrue((boolean)(Iterables.last(messages.sentTo(this.member1)) instanceof RaftMessages.Heartbeat));
        Assert.assertTrue((boolean)(Iterables.last(messages.sentTo(this.member2)) instanceof RaftMessages.Heartbeat));
    }

    @Test
    public void shouldThrowExceptionIfReceivesClientRequestWithNoLeaderElected() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        try {
            raft.getLeader();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NoLeaderFoundException noLeaderFoundException) {
            // empty catch block
        }
    }

    @Test
    public void shouldPersistAtSpecifiedLogIndex() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).raftLog(this.raftLog).build();
        this.raftLog.append(new RaftLogEntry[]{new RaftLogEntry(0L, (ReplicatedContent)new MemberIdSet(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2})))});
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.appendEntriesRequest().from(this.member1).prevLogIndex(0L).prevLogTerm(0L).leaderTerm(0L).logEntry(new RaftLogEntry(0L, (ReplicatedContent)this.data1)).build());
        Assert.assertEquals((long)1L, (long)this.raftLog.appendIndex());
        Assert.assertEquals((Object)this.data1, (Object)RaftLogHelper.readLogEntry((ReadableRaftLog)this.raftLog, 1L).content());
    }

    @Test
    public void newMembersShouldBeIncludedInHeartbeatMessages() throws Exception {
        DirectNetworking network = new DirectNetworking();
        final MemberId newMember = RaftTestMember.member(99);
        DirectNetworking directNetworking = network;
        directNetworking.getClass();
        DirectNetworking.Inbound newMemberInbound = new DirectNetworking.Inbound(directNetworking, newMember);
        final OutboundMessageCollector messages = new OutboundMessageCollector();
        newMemberInbound.registerHandler((Inbound.MessageHandler)new Inbound.MessageHandler<RaftMessages.RaftMessage>(){

            public void handle(RaftMessages.RaftMessage message) {
                messages.send(newMember, message);
            }
        });
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).outbound(messages).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        raft.handle((RaftMessages.RaftMessage)TestMessageBuilders.voteResponse().from(this.member1).term(1L).grant().build());
        raft.setTargetMembershipSet(Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2, newMember}));
        network.processMessages();
        timeouts.invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.HEARTBEAT);
        network.processMessages();
        Assert.assertEquals(RaftMessages.AppendEntries.Request.class, messages.sentTo(newMember).get(0).getClass());
    }

    @Test
    public void shouldMonitorLeaderNotFound() throws Exception {
        ControlledRenewableTimeoutService timeouts = new ControlledRenewableTimeoutService();
        Monitors monitors = new Monitors();
        StubLeaderNotFoundMonitor leaderNotFoundMonitor = new StubLeaderNotFoundMonitor();
        monitors.addMonitorListener((Object)leaderNotFoundMonitor, new String[0]);
        RaftMachine raft = new RaftMachineBuilder(this.myself, 3, RaftTestMemberSetBuilder.INSTANCE).timeoutService(timeouts).monitors(monitors).build();
        raft.installCoreState(new RaftCoreState(new MembershipEntry(0L, Iterators.asSet((Object[])new MemberId[]{this.myself, this.member1, this.member2}))));
        try {
            raft.getLeader();
            Assert.fail((String)"Should have thrown exception");
        }
        catch (NoLeaderFoundException e) {
            Assert.assertEquals((long)1L, (long)leaderNotFoundMonitor.leaderNotFoundExceptions());
        }
    }

    private class StubLeaderNotFoundMonitor
    implements LeaderNotFoundMonitor {
        long count = 0L;

        private StubLeaderNotFoundMonitor() {
        }

        public long leaderNotFoundExceptions() {
            return this.count;
        }

        public void increment() {
            ++this.count;
        }
    }

    private static class TestDatabaseHealth
    extends DatabaseHealth {
        private boolean hasPanicked = false;

        public TestDatabaseHealth() {
            super(new DatabasePanicEventGenerator(new KernelEventHandlers((Log)NullLog.getInstance())), (Log)NullLog.getInstance());
        }

        public void panic(Throwable cause) {
            this.hasPanicked = true;
        }

        public boolean hasPanicked() {
            return this.hasPanicked;
        }
    }

    private static class ExplodingRaftLog
    implements RaftLog {
        private boolean startExploding = false;

        private ExplodingRaftLog() {
        }

        public long append(RaftLogEntry ... entries) throws IOException {
            if (this.startExploding) {
                throw new IOException("Boom! append");
            }
            return 0L;
        }

        public void truncate(long fromIndex) throws IOException {
            throw new IOException("Boom! truncate");
        }

        public long prune(long safeIndex) {
            return -1L;
        }

        public long appendIndex() {
            return -1L;
        }

        public long prevIndex() {
            return -1L;
        }

        public long readEntryTerm(long logIndex) throws IOException {
            return -1L;
        }

        public RaftLogCursor getEntryCursor(long fromIndex) throws IOException {
            if (this.startExploding) {
                throw new IOException("Boom! entry cursor");
            }
            return RaftLogCursor.empty();
        }

        public long skip(long index, long term) {
            return -1L;
        }

        public void startExploding() {
            this.startExploding = true;
        }
    }
}

