/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.Message;
import org.neo4j.causalclustering.messaging.Outbound;

public class OutboundMessageCollector
implements Outbound<MemberId, RaftMessages.RaftMessage> {
    Map<MemberId, List<RaftMessages.RaftMessage>> sentMessages = new HashMap<MemberId, List<RaftMessages.RaftMessage>>();

    public void clear() {
        this.sentMessages.clear();
    }

    public void send(MemberId to, RaftMessages.RaftMessage message) {
        this.raftMessages(to).add(message);
    }

    private List<RaftMessages.RaftMessage> raftMessages(MemberId to) {
        List<RaftMessages.RaftMessage> messagesToMember = this.sentMessages.get(to);
        if (messagesToMember == null) {
            messagesToMember = new ArrayList<RaftMessages.RaftMessage>();
            this.sentMessages.put(to, messagesToMember);
        }
        return messagesToMember;
    }

    public List<RaftMessages.RaftMessage> sentTo(MemberId member) {
        List<RaftMessages.RaftMessage> messages = this.sentMessages.get(member);
        if (messages == null) {
            messages = new ArrayList<RaftMessages.RaftMessage>();
        }
        return messages;
    }

    public boolean hasAnyEntriesTo(MemberId member) {
        List<RaftMessages.RaftMessage> messages = this.sentMessages.get(member);
        return messages != null && messages.size() != 0;
    }

    public boolean hasEntriesTo(MemberId member, RaftLogEntry ... expectedMessages) {
        ArrayList actualMessages = new ArrayList();
        for (Message message : this.sentTo(member)) {
            if (!(message instanceof RaftMessages.AppendEntries.Request)) continue;
            Collections.addAll(actualMessages, ((RaftMessages.AppendEntries.Request)message).entries());
        }
        return actualMessages.containsAll(Arrays.asList(expectedMessages));
    }
}

