/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.causalclustering.core.consensus.DirectNetworking;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.RaftTestFixture;
import org.neo4j.causalclustering.core.consensus.ReplicatedInteger;
import org.neo4j.causalclustering.core.consensus.log.RaftLogHelper;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.MembershipEntry;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.snapshot.RaftCoreState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.RaftTestMember;

public class CatchUpTest {
    @Test
    public void happyClusterPropagatesUpdates() throws Throwable {
        DirectNetworking net = new DirectNetworking();
        MemberId leader = RaftTestMember.member(0);
        MemberId[] allMembers = new MemberId[]{leader, RaftTestMember.member(1), RaftTestMember.member(2)};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, allMembers);
        fixture.bootstrap(allMembers);
        MemberId leaderMember = fixture.members().withId(leader).member();
        fixture.members().withId(leader).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        fixture.members().withId(leader).raftInstance().handle((RaftMessages.RaftMessage)new RaftMessages.NewEntry.Request(leaderMember, (ReplicatedContent)ReplicatedInteger.valueOf(42)));
        net.processMessages();
        for (MemberId aMember : allMembers) {
            Assert.assertThat(this.integerValues((ReadableRaftLog)fixture.members().withId(aMember).raftLog()), (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{42}));
        }
    }

    @Test
    public void newMemberWithNoLogShouldCatchUpFromPeers() throws Throwable {
        DirectNetworking net = new DirectNetworking();
        MemberId leaderId = RaftTestMember.member(0);
        MemberId sleepyId = RaftTestMember.member(2);
        MemberId[] awakeMembers = new MemberId[]{leaderId, RaftTestMember.member(1)};
        MemberId[] allMembers = new MemberId[]{leaderId, RaftTestMember.member(1), sleepyId};
        RaftTestFixture fixture = new RaftTestFixture(net, 3, allMembers);
        fixture.bootstrap(allMembers);
        fixture.members().withId(leaderId).raftInstance().installCoreState(new RaftCoreState(new MembershipEntry(0L, new HashSet<MemberId>(Arrays.asList(allMembers)))));
        fixture.members().withId(leaderId).timeoutService().invokeTimeout((RenewableTimeoutService.TimeoutName)RaftMachine.Timeouts.ELECTION);
        net.processMessages();
        MemberId leader = fixture.members().withId(leaderId).member();
        net.disconnect(sleepyId);
        fixture.members().withId(leaderId).raftInstance().handle((RaftMessages.RaftMessage)new RaftMessages.NewEntry.Request(leader, (ReplicatedContent)ReplicatedInteger.valueOf(10)));
        fixture.members().withId(leaderId).raftInstance().handle((RaftMessages.RaftMessage)new RaftMessages.NewEntry.Request(leader, (ReplicatedContent)ReplicatedInteger.valueOf(20)));
        fixture.members().withId(leaderId).raftInstance().handle((RaftMessages.RaftMessage)new RaftMessages.NewEntry.Request(leader, (ReplicatedContent)ReplicatedInteger.valueOf(30)));
        fixture.members().withId(leaderId).raftInstance().handle((RaftMessages.RaftMessage)new RaftMessages.NewEntry.Request(leader, (ReplicatedContent)ReplicatedInteger.valueOf(40)));
        net.processMessages();
        for (MemberId awakeMember : awakeMembers) {
            Assert.assertThat(this.integerValues((ReadableRaftLog)fixture.members().withId(awakeMember).raftLog()), (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{10, 20, 30, 40}));
        }
        Assert.assertThat(this.integerValues((ReadableRaftLog)fixture.members().withId(sleepyId).raftLog()), (Matcher)Matchers.empty());
        net.reconnect(sleepyId);
        Thread.sleep(500L);
        net.processMessages();
        Assert.assertThat(this.integerValues((ReadableRaftLog)fixture.members().withId(sleepyId).raftLog()), (Matcher)CoreMatchers.hasItems((Object[])new Integer[]{10, 20, 30, 40}));
    }

    private List<Integer> integerValues(ReadableRaftLog log) throws IOException {
        ArrayList<Integer> actual = new ArrayList<Integer>();
        for (long logIndex = 0L; logIndex <= log.appendIndex(); ++logIndex) {
            ReplicatedContent content = RaftLogHelper.readLogEntry(log, logIndex).content();
            if (!(content instanceof ReplicatedInteger)) continue;
            ReplicatedInteger integer = (ReplicatedInteger)content;
            actual.add(integer.get());
        }
        return actual;
    }
}

