/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.channel.ChannelHandlerContext;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestHandler;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.util.Cursors;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class TxPullRequestHandlerTest {
    private static final int BATCH_SIZE = 3;
    private final ChannelHandlerContext context = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    @Test
    public void shouldRespondWithCompleteStreamOfTransactions() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        Mockito.when((Object)logicalTransactionStore.getTransactions(14L)).thenReturn((Object)Cursors.txCursor((Cursor)Cursors.cursor((Object[])new CommittedTransactionRepresentation[]{TxPullRequestHandlerTest.tx(14), TxPullRequestHandlerTest.tx(15)})));
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> storeId, () -> true, () -> transactionIdStore, () -> logicalTransactionStore, 3, new Monitors(), (LogProvider)NullLogProvider.getInstance());
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(13L, storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.times((int)2))).write((Object)ResponseMessageType.TX);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxPullResponse(storeId, TxPullRequestHandlerTest.tx(14)));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxPullResponse(storeId, TxPullRequestHandlerTest.tx(15)));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxStreamFinishedResponse(CatchupResult.SUCCESS_END_OF_STREAM));
    }

    @Test
    public void shouldRespondWithBatchOfTransactions() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        Mockito.when((Object)logicalTransactionStore.getTransactions(14L)).thenReturn((Object)Cursors.txCursor((Cursor)Cursors.cursor((Object[])new CommittedTransactionRepresentation[]{TxPullRequestHandlerTest.tx(14), TxPullRequestHandlerTest.tx(15), TxPullRequestHandlerTest.tx(16), TxPullRequestHandlerTest.tx(17)})));
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> storeId, () -> true, () -> transactionIdStore, () -> logicalTransactionStore, 3, new Monitors(), (LogProvider)NullLogProvider.getInstance());
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(13L, storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.times((int)3))).write((Object)ResponseMessageType.TX);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxPullResponse(storeId, TxPullRequestHandlerTest.tx(14)));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxPullResponse(storeId, TxPullRequestHandlerTest.tx(15)));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxPullResponse(storeId, TxPullRequestHandlerTest.tx(16)));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxStreamFinishedResponse(CatchupResult.SUCCESS_END_OF_BATCH));
    }

    @Test
    public void shouldRespondWithEndOfStreamIfThereAreNoTransactions() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)14L);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> storeId, () -> true, () -> transactionIdStore, () -> logicalTransactionStore, 3, new Monitors(), (LogProvider)NullLogProvider.getInstance());
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(14L, storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxStreamFinishedResponse(CatchupResult.SUCCESS_END_OF_STREAM));
    }

    @Test
    public void shouldRespondWithoutTransactionsIfTheyDoNotExist() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)15L);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        Mockito.when((Object)logicalTransactionStore.getTransactions(14L)).thenThrow(new Throwable[]{new NoSuchTransactionException(14L)});
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> storeId, () -> true, () -> transactionIdStore, () -> logicalTransactionStore, 3, new Monitors(), (LogProvider)this.logProvider);
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(13L, storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).write((Object)ResponseMessageType.TX);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxStreamFinishedResponse(CatchupResult.E_TRANSACTION_PRUNED));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(TxPullRequestHandler.class).info("Failed to serve TxPullRequest for tx %d because the transaction does not exist.", new Object[]{14L})});
    }

    @Test
    public void shouldNotStreamTxEntriesIfStoreIdMismatches() throws Exception {
        StoreId serverStoreId = new StoreId(1L, 2L, 3L, 4L);
        StoreId clientStoreId = new StoreId(5L, 6L, 7L, 8L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> serverStoreId, () -> true, () -> transactionIdStore, () -> logicalTransactionStore, 3, new Monitors(), (LogProvider)this.logProvider);
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(1L, clientStoreId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).write((Object)ResponseMessageType.TX);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxStreamFinishedResponse(CatchupResult.E_STORE_ID_MISMATCH));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(TxPullRequestHandler.class).info("Failed to serve TxPullRequest for tx %d and storeId %s because that storeId is different from this machine with %s", new Object[]{2L, clientStoreId, serverStoreId})});
    }

    @Test
    public void shouldNotStreamTxsAndReportErrorIfTheLocalDatabaseIsNotAvailable() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        LogicalTransactionStore logicalTransactionStore = (LogicalTransactionStore)Mockito.mock(LogicalTransactionStore.class);
        TxPullRequestHandler txPullRequestHandler = new TxPullRequestHandler(new CatchupServerProtocol(), () -> storeId, () -> false, () -> transactionIdStore, () -> logicalTransactionStore, 3, new Monitors(), (LogProvider)this.logProvider);
        txPullRequestHandler.channelRead0(this.context, new TxPullRequest(1L, storeId));
        ((ChannelHandlerContext)Mockito.verify((Object)this.context, (VerificationMode)Mockito.never())).write((Object)ResponseMessageType.TX);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)ResponseMessageType.TX_STREAM_FINISHED);
        ((ChannelHandlerContext)Mockito.verify((Object)this.context)).write((Object)new TxStreamFinishedResponse(CatchupResult.E_STORE_UNAVAILABLE));
        this.logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(TxPullRequestHandler.class).info("Failed to serve TxPullRequest for tx %d because the local database is unavailable.", new Object[]{2L})});
    }

    private static CommittedTransactionRepresentation tx(int id) {
        return new CommittedTransactionRepresentation(new LogEntryStart(id, id, (long)id, (long)(id - 1), new byte[0], LogPosition.UNSPECIFIED), Commands.transactionRepresentation((Command[])new Command[]{Commands.createNode((long)0L, (long[])new long[0])}), (LogEntryCommit)new OnePhaseCommit((long)id, (long)id));
    }
}

