/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpWriter;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.Commands;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.test.rule.NeoStoreDataSourceRule;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class TransactionLogCatchUpWriterTest {
    @Rule
    public final TestDirectory dir = TestDirectory.testDirectory(this.getClass());
    @Rule
    public final DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    private PageCache pageCache;
    private FileSystemAbstraction fs;
    private File storeDir;

    @Before
    public void setup() throws IOException {
        this.storeDir = this.dir.directory("graph.db");
        this.fs = this.fsRule.get();
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
    }

    @Test
    public void shouldCreateTransactionLogWithCheckpoint() throws Exception {
        org.neo4j.kernel.impl.store.StoreId storeId = this.simulateStoreCopy();
        int fromTxId = 37;
        int endTxId = fromTxId + 5;
        TransactionLogCatchUpWriter catchUpWriter = new TransactionLogCatchUpWriter(this.storeDir, this.fs, this.pageCache, (LogProvider)NullLogProvider.getInstance(), (long)fromTxId, true);
        for (int i = fromTxId; i <= endTxId; ++i) {
            catchUpWriter.onTxReceived(new TxPullResponse(this.toCasualStoreId(storeId), TransactionLogCatchUpWriterTest.tx(i)));
        }
        catchUpWriter.close();
        this.verifyTransactionsInLog(fromTxId, endTxId);
        this.verifyCheckpointInLog();
    }

    private void verifyCheckpointInLog() throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader((CommandReaderFactory)new RecordStorageCommandReaderFactory());
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, this.fs);
        LatestCheckPointFinder checkPointFinder = new LatestCheckPointFinder(logFiles, this.fs, (LogEntryReader)logEntryReader);
        LatestCheckPointFinder.LatestCheckPoint checkPoint = checkPointFinder.find(0L);
        Assert.assertNotNull((Object)checkPoint.checkPoint);
        Assert.assertTrue((boolean)checkPoint.commitsAfterCheckPoint);
    }

    private void verifyTransactionsInLog(long fromTxId, long endTxId) throws IOException {
        long expectedTxId = fromTxId;
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, this.fs);
        PhysicalLogVersionedStoreChannel versionedStoreChannel = PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)this.fs, (long)0L, (boolean)false);
        try (ReadAheadLogChannel channel = new ReadAheadLogChannel((LogVersionedStoreChannel)versionedStoreChannel, LogVersionBridge.NO_MORE_CHANNELS, 1024);
             PhysicalTransactionCursor txCursor = new PhysicalTransactionCursor((ReadableClosablePositionAwareChannel)channel, (LogEntryReader)new VersionAwareLogEntryReader());){
            while (txCursor.next()) {
                CommittedTransactionRepresentation tx = txCursor.get();
                long txId = tx.getCommitEntry().getTxId();
                MatcherAssert.assertThat((Object)expectedTxId, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(endTxId)));
                Assert.assertEquals((long)expectedTxId, (long)txId);
                ++expectedTxId;
            }
        }
    }

    private org.neo4j.kernel.impl.store.StoreId simulateStoreCopy() throws IOException {
        org.neo4j.kernel.impl.store.StoreId storeId;
        NeoStoreDataSource ds = this.dsRule.getDataSource(this.storeDir, this.fs, this.pageCache, Collections.emptyMap());
        try (Lifespan ignored = new Lifespan(new Lifecycle[]{ds});){
            storeId = ds.getStoreId();
        }
        PhysicalLogFiles logFiles = new PhysicalLogFiles(this.storeDir, (FileSystemAbstraction)this.fsRule.get());
        logFiles.accept((file, version) -> file.delete());
        return storeId;
    }

    private StoreId toCasualStoreId(org.neo4j.kernel.impl.store.StoreId storeId) {
        return new StoreId(storeId.getCreationTime(), storeId.getRandomId(), storeId.getUpgradeTime(), storeId.getUpgradeId());
    }

    private static CommittedTransactionRepresentation tx(int id) {
        return new CommittedTransactionRepresentation(new LogEntryStart(id, id, (long)id, (long)(id - 1), new byte[0], LogPosition.UNSPECIFIED), Commands.transactionRepresentation((Command[])new Command[]{Commands.createNode((long)0L, (long[])new long[0])}), (LogEntryCommit)new OnePhaseCommit((long)id, (long)id));
    }
}

