/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.catchup.CatchUpResponseCallback;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.storecopy.CopiedStoreRecovery;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.catchup.tx.BatchingTxApplier;
import org.neo4j.causalclustering.catchup.tx.CatchupPollingProcess;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullResponse;
import org.neo4j.causalclustering.core.consensus.schedule.ControlledRenewableTimeoutService;
import org.neo4j.causalclustering.core.consensus.schedule.RenewableTimeoutService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.causalclustering.messaging.CatchUpRequest;
import org.neo4j.causalclustering.messaging.routing.CoreMemberSelectionStrategy;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CatchupPollingProcessTest {
    private final CatchUpClient catchUpClient = (CatchUpClient)Mockito.mock(CatchUpClient.class);
    private final CoreMemberSelectionStrategy serverSelection = (CoreMemberSelectionStrategy)Mockito.mock(CoreMemberSelectionStrategy.class);
    private final MemberId coreMemberId = (MemberId)Mockito.mock(MemberId.class);
    private final TransactionIdStore idStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final BatchingTxApplier txApplier = (BatchingTxApplier)Mockito.mock(BatchingTxApplier.class);
    private final ControlledRenewableTimeoutService timeoutService = new ControlledRenewableTimeoutService();
    private final long txPullIntervalMillis = 100L;
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final StoreFetcher storeFetcher = (StoreFetcher)Mockito.mock(StoreFetcher.class);
    private final CopiedStoreRecovery copiedStoreRecovery = (CopiedStoreRecovery)Mockito.mock(CopiedStoreRecovery.class);
    private final StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
    private final LocalDatabase localDatabase = (LocalDatabase)Mockito.mock(LocalDatabase.class);
    private final Lifecycle startStopOnStoreCopy;
    private final CatchupPollingProcess txPuller;

    public CatchupPollingProcessTest() {
        Mockito.when((Object)this.localDatabase.storeId()).thenReturn((Object)this.storeId);
        this.startStopOnStoreCopy = (Lifecycle)Mockito.mock(Lifecycle.class);
        this.txPuller = new CatchupPollingProcess((LogProvider)NullLogProvider.getInstance(), this.fs, this.localDatabase, this.startStopOnStoreCopy, this.storeFetcher, this.catchUpClient, this.serverSelection, (RenewableTimeoutService)this.timeoutService, 100L, this.txApplier, new Monitors(), this.copiedStoreRecovery, () -> (DatabaseHealth)Mockito.mock(DatabaseHealth.class));
    }

    @Before
    public void before() throws Throwable {
        Mockito.when((Object)this.idStore.getLastCommittedTransactionId()).thenReturn((Object)1L);
        Mockito.when((Object)this.serverSelection.coreMember()).thenReturn((Object)this.coreMemberId);
    }

    @Test
    public void shouldSendPullRequestOnTick() throws Throwable {
        this.txPuller.start();
        long lastAppliedTxId = 99L;
        Mockito.when((Object)this.txApplier.lastQueuedTxId()).thenReturn((Object)lastAppliedTxId);
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        ((CatchUpClient)Mockito.verify((Object)this.catchUpClient)).makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class));
    }

    @Test
    public void shouldKeepMakingPullRequestsUntilEndOfStream() throws Throwable {
        this.txPuller.start();
        long lastAppliedTxId = 99L;
        Mockito.when((Object)this.txApplier.lastQueuedTxId()).thenReturn((Object)lastAppliedTxId);
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class))).thenReturn((Object)CatchupResult.SUCCESS_END_OF_BATCH, (Object[])new CatchupResult[]{CatchupResult.SUCCESS_END_OF_STREAM});
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        ((CatchUpClient)Mockito.verify((Object)this.catchUpClient, (VerificationMode)Mockito.times((int)2))).makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class));
    }

    @Test
    public void shouldRenewTxPullTimeoutOnSuccessfulTxPulling() throws Throwable {
        this.txPuller.start();
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class))).thenReturn((Object)CatchupResult.SUCCESS_END_OF_STREAM);
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        ((RenewableTimeoutService.RenewableTimeout)Mockito.verify((Object)this.timeoutService.getTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT))).renew();
    }

    @Test
    public void nextStateShouldBeStoreCopyingIfRequestedTransactionHasBeenPrunedAway() throws Throwable {
        this.txPuller.start();
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class))).thenReturn((Object)CatchupResult.E_TRANSACTION_PRUNED);
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        Assert.assertEquals((Object)CatchupPollingProcess.State.STORE_COPYING, (Object)this.txPuller.state());
    }

    @Test
    public void nextStateShouldBeTxPullingAfterASuccessfulStoreCopy() throws Throwable {
        this.txPuller.start();
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class))).thenReturn((Object)CatchupResult.E_TRANSACTION_PRUNED);
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).stop();
        ((Lifecycle)Mockito.verify((Object)this.startStopOnStoreCopy)).stop();
        ((StoreFetcher)Mockito.verify((Object)this.storeFetcher)).copyStore((MemberId)Matchers.any(MemberId.class), (StoreId)Matchers.eq((Object)this.storeId), (File)Matchers.any(File.class));
        ((LocalDatabase)Mockito.verify((Object)this.localDatabase)).start();
        ((Lifecycle)Mockito.verify((Object)this.startStopOnStoreCopy)).start();
        ((BatchingTxApplier)Mockito.verify((Object)this.txApplier)).refreshFromNewStore();
        Assert.assertEquals((Object)CatchupPollingProcess.State.TX_PULLING, (Object)this.txPuller.state());
    }

    @Test
    public void shouldNotRenewTheTimeoutIfInPanicState() throws Throwable {
        this.txPuller.start();
        CatchUpResponseCallback callback = (CatchUpResponseCallback)Mockito.mock(CatchUpResponseCallback.class);
        ((CatchUpResponseCallback)Mockito.doThrow((Throwable)new RuntimeException("Panic all the things")).when((Object)callback)).onTxPullResponse((CompletableFuture)Matchers.any(CompletableFuture.class), (TxPullResponse)Matchers.any(TxPullResponse.class));
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        Assert.assertEquals((Object)CatchupPollingProcess.State.PANIC, (Object)this.txPuller.state());
        ((RenewableTimeoutService.RenewableTimeout)Mockito.verify((Object)this.timeoutService.getTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT), (VerificationMode)Mockito.never())).renew();
    }

    @Test
    public void shouldNotSignalOperationalUntilPulling() throws Throwable {
        Mockito.when((Object)this.catchUpClient.makeBlockingRequest((MemberId)Matchers.any(MemberId.class), (CatchUpRequest)Matchers.any(TxPullRequest.class), (CatchUpResponseCallback)Matchers.any(CatchUpResponseCallback.class))).thenReturn((Object)CatchupResult.E_TRANSACTION_PRUNED, (Object[])new CatchupResult[]{CatchupResult.SUCCESS_END_OF_BATCH, CatchupResult.SUCCESS_END_OF_STREAM});
        this.txPuller.start();
        Future operationalFuture = this.txPuller.upToDateFuture();
        Assert.assertFalse((boolean)operationalFuture.isDone());
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        Assert.assertFalse((boolean)operationalFuture.isDone());
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        Assert.assertFalse((boolean)operationalFuture.isDone());
        this.timeoutService.invokeTimeout((RenewableTimeoutService.TimeoutName)CatchupPollingProcess.Timeouts.TX_PULLER_TIMEOUT);
        Assert.assertTrue((boolean)operationalFuture.isDone());
        Assert.assertTrue((boolean)((Boolean)operationalFuture.get()));
        Assert.assertEquals((Object)CatchupPollingProcess.State.TX_PULLING, (Object)this.txPuller.state());
    }
}

