/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.tx.BatchingTxApplier;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class BatchingTxApplierTest {
    private final TransactionIdStore idStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final TransactionCommitProcess commitProcess = (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class);
    private final DatabaseHealth dbHealth = (DatabaseHealth)Mockito.mock(DatabaseHealth.class);
    private final long startTxId = 31L;
    private final int maxBatchSize = 16;
    private final BatchingTxApplier txApplier = new BatchingTxApplier(16, () -> this.idStore, () -> this.commitProcess, new Monitors(), (LogProvider)NullLogProvider.getInstance());

    @Before
    public void before() throws Throwable {
        Mockito.when((Object)this.idStore.getLastCommittedTransactionId()).thenReturn((Object)31L);
        this.txApplier.start();
    }

    @After
    public void after() throws Throwable {
        this.txApplier.stop();
    }

    @Test
    public void shouldHaveCorrectDefaults() throws Throwable {
        Assert.assertEquals((long)31L, (long)this.txApplier.lastQueuedTxId());
    }

    @Test
    public void shouldApplyBatch() throws Exception {
        this.txApplier.queue(this.createTxWithId(32L));
        this.txApplier.queue(this.createTxWithId(33L));
        this.txApplier.queue(this.createTxWithId(34L));
        this.txApplier.applyBatch();
        Assert.assertEquals((long)34L, (long)this.txApplier.lastQueuedTxId());
        this.assertTransactionsCommitted(32L, 3L);
    }

    @Test
    public void shouldIgnoreOutOfOrderTransactions() throws Exception {
        this.txApplier.queue(this.createTxWithId(35L));
        this.txApplier.queue(this.createTxWithId(32L));
        this.txApplier.queue(this.createTxWithId(34L));
        this.txApplier.queue(this.createTxWithId(33L));
        this.txApplier.queue(this.createTxWithId(34L));
        this.txApplier.queue(this.createTxWithId(36L));
        this.txApplier.queue(this.createTxWithId(36L));
        this.txApplier.queue(this.createTxWithId(35L));
        this.txApplier.queue(this.createTxWithId(35L));
        this.txApplier.queue(this.createTxWithId(35L));
        this.txApplier.queue(this.createTxWithId(37L));
        this.txApplier.applyBatch();
        this.assertTransactionsCommitted(32L, 4L);
    }

    @Test
    public void shouldBeAbleToQueueMaxBatchSize() throws Exception {
        long endTxId = 47L;
        for (long txId = 32L; txId <= endTxId; ++txId) {
            this.txApplier.queue(this.createTxWithId(txId));
        }
        this.txApplier.applyBatch();
        this.assertTransactionsCommitted(32L, 16L);
    }

    @Test(timeout=3000L)
    public void shouldGiveUpQueueingOnStop() throws Throwable {
        for (int i = 1; i <= 16; ++i) {
            this.txApplier.queue(this.createTxWithId(31L + (long)i));
        }
        final CountDownLatch latch = new CountDownLatch(1);
        Thread thread = new Thread(){

            @Override
            public void run() {
                latch.countDown();
                try {
                    BatchingTxApplierTest.this.txApplier.queue(BatchingTxApplierTest.this.createTxWithId(48L));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        thread.start();
        latch.await();
        this.txApplier.stop();
        thread.join();
    }

    private CommittedTransactionRepresentation createTxWithId(long txId) {
        CommittedTransactionRepresentation tx = (CommittedTransactionRepresentation)Mockito.mock(CommittedTransactionRepresentation.class);
        LogEntryCommit commitEntry = (LogEntryCommit)Mockito.mock(LogEntryCommit.class);
        Mockito.when((Object)commitEntry.getTxId()).thenReturn((Object)txId);
        TransactionRepresentation txRep = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)tx.getTransactionRepresentation()).thenReturn((Object)txRep);
        Mockito.when((Object)tx.getCommitEntry()).thenReturn((Object)commitEntry);
        return tx;
    }

    private void assertTransactionsCommitted(long startTxId, long expectedCount) throws TransactionFailureException {
        ArgumentCaptor batchCaptor = ArgumentCaptor.forClass(TransactionToApply.class);
        ((TransactionCommitProcess)Mockito.verify((Object)this.commitProcess)).commit((TransactionToApply)batchCaptor.capture(), (CommitEvent)Matchers.eq((Object)CommitEvent.NULL), (TransactionApplicationMode)Matchers.eq((Object)TransactionApplicationMode.EXTERNAL));
        TransactionToApply batch = (TransactionToApply)Iterables.single((Iterable)batchCaptor.getAllValues());
        long expectedTxId = startTxId;
        long count = 0L;
        while (batch != null) {
            Assert.assertEquals((long)expectedTxId, (long)batch.transactionId());
            ++expectedTxId;
            batch = batch.next();
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }
}

