/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.TxPullRequestResult;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyClient;
import org.neo4j.causalclustering.catchup.storecopy.StoreCopyFailedException;
import org.neo4j.causalclustering.catchup.storecopy.StoreFetcher;
import org.neo4j.causalclustering.catchup.storecopy.StoreFileStreams;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpFactory;
import org.neo4j.causalclustering.catchup.tx.TransactionLogCatchUpWriter;
import org.neo4j.causalclustering.catchup.tx.TxPullClient;
import org.neo4j.causalclustering.catchup.tx.TxPullResponseListener;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class StoreFetcherTest {
    @Test
    public void shouldCopyStoreFilesAndPullTransactions() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        TxPullClient txPullClient = (TxPullClient)Mockito.mock(TxPullClient.class);
        Mockito.when((Object)txPullClient.pullTransactions((MemberId)Matchers.any(), (StoreId)Matchers.any(), Matchers.anyLong(), (TxPullResponseListener)Matchers.any())).thenReturn((Object)new TxPullRequestResult(CatchupResult.SUCCESS_END_OF_STREAM, 13L));
        TransactionLogCatchUpWriter writer = (TransactionLogCatchUpWriter)Mockito.mock(TransactionLogCatchUpWriter.class);
        StoreFetcher fetcher = new StoreFetcher((LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), null, storeCopyClient, txPullClient, this.factory(writer), new Monitors());
        MemberId localhost = new MemberId(UUID.randomUUID());
        fetcher.copyStore(localhost, storeId, new File("destination"));
        ((StoreCopyClient)Mockito.verify((Object)storeCopyClient)).copyStoreFiles((MemberId)Matchers.eq((Object)localhost), (StoreId)Matchers.eq((Object)storeId), (StoreFileStreams)Matchers.any(StoreFileStreams.class));
        ((TxPullClient)Mockito.verify((Object)txPullClient)).pullTransactions((MemberId)Matchers.eq((Object)localhost), (StoreId)Matchers.eq((Object)storeId), Matchers.anyLong(), (TxPullResponseListener)Matchers.any(TxPullResponseListener.class));
    }

    @Test
    public void shouldSetLastPulledTransactionId() throws Exception {
        long lastFlushedTxId = 12L;
        StoreId wantedStoreId = new StoreId(1L, 2L, 3L, 4L);
        MemberId localhost = new MemberId(UUID.randomUUID());
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        Mockito.when((Object)storeCopyClient.copyStoreFiles((MemberId)Matchers.eq((Object)localhost), (StoreId)Matchers.eq((Object)wantedStoreId), (StoreFileStreams)Matchers.any(StoreFileStreams.class))).thenReturn((Object)lastFlushedTxId);
        TxPullClient txPullClient = (TxPullClient)Mockito.mock(TxPullClient.class);
        Mockito.when((Object)txPullClient.pullTransactions((MemberId)Matchers.eq((Object)localhost), (StoreId)Matchers.eq((Object)wantedStoreId), Matchers.anyLong(), (TxPullResponseListener)Matchers.any(TxPullResponseListener.class))).thenReturn((Object)new TxPullRequestResult(CatchupResult.SUCCESS_END_OF_STREAM, 13L));
        TransactionLogCatchUpWriter writer = (TransactionLogCatchUpWriter)Mockito.mock(TransactionLogCatchUpWriter.class);
        StoreFetcher fetcher = new StoreFetcher((LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), null, storeCopyClient, txPullClient, this.factory(writer), new Monitors());
        fetcher.copyStore(localhost, wantedStoreId, new File("destination"));
        long previousTxId = lastFlushedTxId - 1L;
        ((TxPullClient)Mockito.verify((Object)txPullClient)).pullTransactions((MemberId)Matchers.eq((Object)localhost), (StoreId)Matchers.eq((Object)wantedStoreId), Matchers.eq((long)previousTxId), (TxPullResponseListener)Matchers.any(TxPullResponseListener.class));
    }

    @Test
    public void shouldCloseDownTxLogWriterIfTxStreamingFails() throws Exception {
        StoreId storeId = new StoreId(1L, 2L, 3L, 4L);
        StoreCopyClient storeCopyClient = (StoreCopyClient)Mockito.mock(StoreCopyClient.class);
        TxPullClient txPullClient = (TxPullClient)Mockito.mock(TxPullClient.class);
        TransactionLogCatchUpWriter writer = (TransactionLogCatchUpWriter)Mockito.mock(TransactionLogCatchUpWriter.class);
        StoreFetcher fetcher = new StoreFetcher((LogProvider)NullLogProvider.getInstance(), (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class), null, storeCopyClient, txPullClient, this.factory(writer), new Monitors());
        ((TxPullClient)Mockito.doThrow(StoreCopyFailedException.class).when((Object)txPullClient)).pullTransactions((MemberId)Matchers.any(MemberId.class), (StoreId)Matchers.eq((Object)storeId), Matchers.anyLong(), (TxPullResponseListener)Matchers.any(TransactionLogCatchUpWriter.class));
        try {
            fetcher.copyStore(null, storeId, null);
        }
        catch (StoreCopyFailedException storeCopyFailedException) {
            // empty catch block
        }
        ((TransactionLogCatchUpWriter)Mockito.verify((Object)writer)).close();
    }

    private TransactionLogCatchUpFactory factory(TransactionLogCatchUpWriter writer) throws IOException {
        TransactionLogCatchUpFactory factory = (TransactionLogCatchUpFactory)Mockito.mock(TransactionLogCatchUpFactory.class);
        Mockito.when((Object)factory.create((File)Matchers.any(File.class), (FileSystemAbstraction)Matchers.any(FileSystemAbstraction.class), (PageCache)Matchers.any(PageCache.class), (LogProvider)Matchers.any(LogProvider.class), Matchers.anyLong(), Matchers.anyBoolean())).thenReturn((Object)writer);
        return factory;
    }
}

