/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.storecopy;

import io.netty.buffer.ByteBufAllocator;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.causalclustering.catchup.storecopy.FileChunk;
import org.neo4j.causalclustering.catchup.storecopy.FileSender;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class FileSenderTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory((FileSystemAbstraction)this.fsRule.get());
    private final FileSystemAbstraction fs = this.fsRule.get();
    private final Random random = new Random();
    private ByteBufAllocator allocator = (ByteBufAllocator)Mockito.mock(ByteBufAllocator.class);

    @Test
    public void sendEmptyFile() throws Exception {
        File emptyFile = this.testDirectory.file("emptyFile");
        this.fs.create(emptyFile).close();
        FileSender fileSender = new FileSender(this.fs.open(emptyFile, "r"));
        Assert.assertFalse((boolean)fileSender.isEndOfInput());
        Assert.assertEquals((Object)FileChunk.create((byte[])new byte[0], (boolean)true), (Object)fileSender.readChunk(this.allocator));
        Assert.assertNull((Object)fileSender.readChunk(this.allocator));
        Assert.assertTrue((boolean)fileSender.isEndOfInput());
    }

    @Test
    public void sendSmallFile() throws Exception {
        byte[] bytes = new byte[10];
        this.random.nextBytes(bytes);
        File smallFile = this.testDirectory.file("smallFile");
        try (StoreChannel storeChannel = this.fs.create(smallFile);){
            storeChannel.write(ByteBuffer.wrap(bytes));
        }
        FileSender fileSender = new FileSender(this.fs.open(smallFile, "r"));
        Assert.assertFalse((boolean)fileSender.isEndOfInput());
        Assert.assertEquals((Object)FileChunk.create((byte[])bytes, (boolean)true), (Object)fileSender.readChunk(this.allocator));
        Assert.assertNull((Object)fileSender.readChunk(this.allocator));
        Assert.assertTrue((boolean)fileSender.isEndOfInput());
    }

    @Test
    public void sendLargeFile() throws Exception {
        int dataSize = 12288;
        byte[] bytes = new byte[dataSize];
        this.random.nextBytes(bytes);
        File smallFile = this.testDirectory.file("smallFile");
        try (StoreChannel storeChannel = this.fs.create(smallFile);){
            storeChannel.write(ByteBuffer.wrap(bytes));
        }
        FileSender fileSender = new FileSender(this.fs.open(smallFile, "r"));
        Assert.assertFalse((boolean)fileSender.isEndOfInput());
        Assert.assertEquals((Object)FileChunk.create((byte[])Arrays.copyOfRange(bytes, 0, 8192), (boolean)false), (Object)fileSender.readChunk(this.allocator));
        Assert.assertEquals((Object)FileChunk.create((byte[])Arrays.copyOfRange(bytes, 8192, bytes.length), (boolean)true), (Object)fileSender.readChunk(this.allocator));
        Assert.assertNull((Object)fileSender.readChunk(this.allocator));
        Assert.assertTrue((boolean)fileSender.isEndOfInput());
    }

    @Test
    public void sendLargeFileWithSizeMultipleOfTheChunkSize() throws Exception {
        byte[] bytes = new byte[24576];
        this.random.nextBytes(bytes);
        File smallFile = this.testDirectory.file("smallFile");
        try (StoreChannel storeChannel = this.fs.create(smallFile);){
            storeChannel.write(ByteBuffer.wrap(bytes));
        }
        FileSender fileSender = new FileSender(this.fs.open(smallFile, "r"));
        Assert.assertFalse((boolean)fileSender.isEndOfInput());
        Assert.assertEquals((Object)FileChunk.create((byte[])Arrays.copyOfRange(bytes, 0, 8192), (boolean)false), (Object)fileSender.readChunk(this.allocator));
        Assert.assertEquals((Object)FileChunk.create((byte[])Arrays.copyOfRange(bytes, 8192, 16384), (boolean)false), (Object)fileSender.readChunk(this.allocator));
        Assert.assertEquals((Object)FileChunk.create((byte[])Arrays.copyOfRange(bytes, 16384, bytes.length), (boolean)true), (Object)fileSender.readChunk(this.allocator));
        Assert.assertNull((Object)fileSender.readChunk(this.allocator));
        Assert.assertTrue((boolean)fileSender.isEndOfInput());
    }
}

