/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.backup;

import java.io.File;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;

public class RestoreClusterUtils {
    public static File createClassicNeo4jStore(File base, FileSystemAbstraction fileSystem, int nodesToCreate, String recordFormat) {
        File existingDbDir = new File(base, "existing");
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(fileSystem).newEmbeddedDatabaseBuilder(existingDbDir).setConfig(GraphDatabaseSettings.record_format, recordFormat).newGraphDatabase();
        for (int i = 0; i < nodesToCreate / 2; ++i) {
            try (Transaction tx = db.beginTx();){
                Node node1 = db.createNode(new Label[]{Label.label((String)("Label-" + i))});
                Node node2 = db.createNode(new Label[]{Label.label((String)("Label-" + i))});
                node1.createRelationshipTo(node2, RelationshipType.withName((String)("REL-" + i)));
                tx.success();
                continue;
            }
        }
        db.shutdown();
        return existingDbDir;
    }
}

