/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.backup;

import java.io.File;
import java.util.HashMap;
import java.util.function.IntFunction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.BackupEmbeddedIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.causalclustering.backup.BackupCoreIT;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.SharedDiscoveryService;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ClusterSeedingIT {
    private Cluster backupCluster;
    private Cluster cluster;
    private FileSystemAbstraction fsa;
    @Rule
    public TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();

    @Before
    public void setup() throws Exception {
        this.fsa = this.fileSystemRule.get();
        HashMap<String, IntFunction<String>> instanceCoreParams = new HashMap<String, IntFunction<String>>();
        instanceCoreParams.put(OnlineBackupSettings.online_backup_server.name(), serverId -> ":" + (8000 + serverId));
        this.backupCluster = new Cluster(this.testDir.directory("cluster-for-backup"), 3, 0, new SharedDiscoveryService(), MapUtil.stringMap((String[])new String[0]), instanceCoreParams, MapUtil.stringMap((String[])new String[0]), new HashMap<String, IntFunction<String>>(), "standard");
        this.cluster = new Cluster(this.testDir.directory("cluster-b"), 3, 0, new SharedDiscoveryService(), MapUtil.stringMap((String[])new String[0]), new HashMap<String, IntFunction<String>>(), MapUtil.stringMap((String[])new String[0]), new HashMap<String, IntFunction<String>>(), "standard");
    }

    @After
    public void after() throws Exception {
        if (this.backupCluster != null) {
            this.backupCluster.shutdown();
        }
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
    }

    private File createBackupUsingCoreCluster() throws Exception {
        File backupDir = this.testDir.directory("backups");
        this.backupCluster.start();
        CoreGraphDatabase db = BackupCoreIT.createSomeData(this.backupCluster);
        String[] args = BackupCoreIT.backupArguments(BackupCoreIT.backupAddress((GraphDatabaseFacade)db), backupDir.getPath());
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])args));
        this.backupCluster.shutdown();
        return backupDir;
    }

    @Test
    public void shouldRestoreBySeedingAllMembers() throws Throwable {
        File backupDir = this.createBackupUsingCoreCluster();
        DbRepresentation before = DbRepresentation.of((File)backupDir);
        this.fsa.copyRecursively(this.testDir.directory("backups"), this.cluster.getCoreMemberById(0).storeDir());
        this.fsa.copyRecursively(this.testDir.directory("backups"), this.cluster.getCoreMemberById(1).storeDir());
        this.fsa.copyRecursively(this.testDir.directory("backups"), this.cluster.getCoreMemberById(2).storeDir());
        this.cluster.start();
        Cluster.dataMatchesEventually(before, this.cluster.coreMembers());
    }

    @Test
    @Ignore(value="need to seed all members for now")
    public void shouldRestoreBySeedingSingleMember() throws Throwable {
        File backupDir = this.createBackupUsingCoreCluster();
        DbRepresentation before = DbRepresentation.of((File)backupDir);
        this.fsa.copyRecursively(this.testDir.directory("backups"), this.cluster.getCoreMemberById(0).storeDir());
        this.cluster.getCoreMemberById(0).start();
        Thread.sleep(2000L);
        this.cluster.getCoreMemberById(1).start();
        this.cluster.getCoreMemberById(2).start();
        Cluster.dataMatchesEventually(before, this.cluster.coreMembers());
    }
}

