/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.backup;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.backup.BackupEmbeddedIT;
import org.neo4j.backup.OnlineBackupSettings;
import org.neo4j.causalclustering.backup.BackupCoreIT;
import org.neo4j.causalclustering.core.CoreGraphDatabase;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.readreplica.ReadReplicaGraphDatabase;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.causalclustering.ClusterRule;
import org.neo4j.test.rule.SuppressOutput;

public class BackupReadReplicaIT {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppress((SuppressOutput.Suppressible[])new SuppressOutput.Suppressible[]{SuppressOutput.System.out, SuppressOutput.System.err});
    @Rule
    public ClusterRule clusterRule = new ClusterRule(BackupReadReplicaIT.class).withNumberOfCoreMembers(3).withSharedCoreParam(OnlineBackupSettings.online_backup_enabled, "false").withNumberOfReadReplicas(1).withSharedReadReplicaParam(OnlineBackupSettings.online_backup_enabled, "true").withInstanceReadReplicaParam(OnlineBackupSettings.online_backup_server, serverId -> ":" + BackupReadReplicaIT.findFreePort(8000, 9000));
    private Cluster cluster;
    private File backupPath;

    @Before
    public void setup() throws Exception {
        this.backupPath = this.clusterRule.testDirectory().cleanDirectory("backup-db");
        this.cluster = this.clusterRule.startCluster();
    }

    private boolean readReplicasUpToDateAsTheLeader(CoreGraphDatabase leader, ReadReplicaGraphDatabase readReplica) {
        long leaderTxId = ((TransactionIdStore)leader.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        long lastClosedTxId = ((TransactionIdStore)readReplica.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        return lastClosedTxId == leaderTxId;
    }

    @Test
    public void makeSureBackupCanBePerformed() throws Throwable {
        CoreGraphDatabase leader = BackupCoreIT.createSomeData(this.cluster);
        ReadReplicaGraphDatabase readReplica = this.cluster.findAnyReadReplica().database();
        Predicates.awaitEx(() -> this.readReplicasUpToDateAsTheLeader(leader, readReplica), (long)1L, (TimeUnit)TimeUnit.MINUTES);
        DbRepresentation beforeChange = DbRepresentation.of((GraphDatabaseService)readReplica);
        String backupAddress = BackupCoreIT.backupAddress((GraphDatabaseFacade)readReplica);
        System.out.println(backupAddress);
        String[] args = BackupCoreIT.backupArguments(backupAddress, this.backupPath.getPath());
        Assert.assertEquals((long)0L, (long)BackupEmbeddedIT.runBackupToolFromOtherJvmToGetExitCode((String[])args));
        DbRepresentation afterChange = DbRepresentation.of((GraphDatabaseService)BackupCoreIT.createSomeData(this.cluster));
        DbRepresentation backupRepresentation = DbRepresentation.of((File)this.backupPath, (Config)BackupCoreIT.getConfig());
        Assert.assertEquals((Object)beforeChange, (Object)backupRepresentation);
        Assert.assertNotEquals((Object)backupRepresentation, (Object)afterChange);
    }

    private static int findFreePort(int startRange, int endRange) {
        InetSocketAddress address = null;
        RuntimeException ex = null;
        for (int port = startRange; port <= endRange; ++port) {
            address = new InetSocketAddress(port);
            try {
                new ServerSocket(address.getPort(), 100, address.getAddress()).close();
                ex = null;
                break;
            }
            catch (IOException e) {
                ex = new RuntimeException(e);
                continue;
            }
        }
        if (ex != null) {
            throw ex;
        }
        assert (address != null);
        return address.getPort();
    }
}

